/*
 * The_xmloperator_project Software License, Version 1.7
 *
 * Copyright (c) 2000 - 2003 The_xmloperator_project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *      "This product includes or uses software developped
 *       by The_xmloperator_project (http://www.xmloperator.net/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. Products derived from this software may not be called "xmloperator",
 *    nor may "xmloperator" appear in their name, without prior written
 *    permission. For written permission, please contact
 *    the xmloperator project administrator.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE_XMLOPERATOR_PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * Further information can be found on the project's site
 * (http://www.xmloperator.net/).
 */
package xmltorng.i2s.util;

import java.util.List;
import java.util.ArrayList;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

import xmltorng.framework.document.relaxng.Name;
import xmltorng.document.relaxng.impl.NameImpl;
import xmltorng.i2s.framework.RepeatableName;
import xmltorng.i2s.framework.PatternHandler;
import xmltorng.i2s.impl.RepeatableNameImpl;

/**
 * This object is used for extracting the content pattern of each element
 *   of a parsed document.
 * The content pattern contains :
 * - the set of name of attribute that the element have,
 * - the list of name of element that the element contains.
 */
public final class PatternExtractor extends DefaultHandler {
  private PatternHandler patternHandler;
  private final List patternStack = new ArrayList();

  public static final void extractPatterns(
      String systemId, PatternHandler patternHandler)
      throws IOException, SAXException, ParserConfigurationException {
    new PatternExtractor(patternHandler).extractPatterns(systemId);
  }

  private PatternExtractor(PatternHandler patternHandler) {
    this.patternHandler = patternHandler;
  }

  private final void extractPatterns(String systemId)
      throws IOException, SAXException, ParserConfigurationException {
    SAXParserFactory factory = SAXParserFactory.newInstance();
    factory.setNamespaceAware(true);
    SAXParser parser = factory.newSAXParser();
    parser.parse(systemId, (DefaultHandler)this);
  }

  private static final Name[] attributeNames(Attributes attributes) {
    int attributeCount = attributes.getLength();
    Name[] attributeNames = new Name[attributeCount];
    for (int k = 0; k < attributeCount; k++)
      attributeNames[k] =
          new NameImpl(attributes.getURI(k), attributes.getLocalName(k));
    return attributeNames;
  }

  ////////////////////////////////
  // ContentHandler implementation
  ////////////////////////////////

  private static final int POSITION_COUNT = 3;
  private static final int POSITION_ELEMENT_NAMES = 1;
  private static final int POSITION_TEXT = 2;
  private static final int POSITION_ATTRIBUTE_NAMES = 3;

  public void startElement(String uri, String localName, String qName,
                           Attributes attributes) throws SAXException {
    if (!this.patternStack.isEmpty()) {
      List repeatableNameList =
          (List)this.patternStack.get(
          patternStack.size() - POSITION_ELEMENT_NAMES);
      int nameCount = repeatableNameList.size();
      RepeatableName lastRepeatableName = nameCount != 0 ?
          (RepeatableName)repeatableNameList.get(nameCount - 1) : null;
      if (lastRepeatableName != null
          && localName.equals(lastRepeatableName.getLocalName())
          && uri.equals(lastRepeatableName.getNsURI()))
        lastRepeatableName.setRepeatable(true);
      else
        repeatableNameList.add(new RepeatableNameImpl(uri, localName, false));
    }
    this.patternStack.add(attributeNames(attributes));
    this.patternStack.add(Boolean.FALSE); // No text content
    List repeatableNameList = new ArrayList();
    this.patternStack.add(repeatableNameList);
  }

  public void endElement(String uri, String localName, String qName)
      throws SAXException {
    int patternIndex = this.patternStack.size();
    List repeatableNameList =
        (List)patternStack.get(patternIndex - POSITION_ELEMENT_NAMES);
    int nameCount = repeatableNameList.size();
    RepeatableName[] repeatableNames = new RepeatableName[nameCount];
    repeatableNameList.toArray(repeatableNames);
    boolean hasText = ((Boolean)patternStack.
                       get(patternIndex - POSITION_TEXT)).booleanValue();
    Name[] attributeNames =
        (Name[])patternStack.get(patternIndex - POSITION_ATTRIBUTE_NAMES);
    this.patternHandler.pattern(
        patternIndex == POSITION_COUNT, new NameImpl(uri, localName),
        attributeNames, hasText, repeatableNames);
    this.patternStack.remove(patternIndex - 1);
    this.patternStack.remove(patternIndex - 2);
    this.patternStack.remove(patternIndex - 3);
  }

  public void characters(char ch[], int start, int length)
      throws SAXException {
    boolean hasSignificantChar = false;
    for (int k = start; k < start + length; k++) {
      char c = ch[k];
      if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
        hasSignificantChar = true;
        break;
      }
    }
    if (hasSignificantChar)
       this.patternStack.set(patternStack.size() - POSITION_TEXT, Boolean.TRUE);
  }
}
