/*
 * The_xmloperator_project Software License, Version 1.7
 *
 * Copyright (c) 2000 - 2003 The_xmloperator_project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *      "This product includes or uses software developped
 *       by The_xmloperator_project (http://www.xmloperator.net/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. Products derived from this software may not be called "xmloperator",
 *    nor may "xmloperator" appear in their name, without prior written
 *    permission. For written permission, please contact
 *    the xmloperator project administrator.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE_XMLOPERATOR_PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * Further information can be found on the project's site
 * (http://www.xmloperator.net/).
 */
package xmltorng.i2s;

import xmltorng.framework.document.relaxng.Name;
import xmltorng.i2s.framework.RepeatableName;
import xmltorng.i2s.framework.PatternCategory;
import xmltorng.i2s.framework.ChoicePatternCategory;
import xmltorng.i2s.framework.GroupPatternCategory;
import xmltorng.i2s.framework.AttributesPatternCategory;
import xmltorng.i2s.impl.EmptyPatternCategory;
import xmltorng.i2s.impl.OptionalRepeatableElementPatternCategory;
import xmltorng.i2s.impl.GroupPatternCategoryImpl;
import xmltorng.i2s.impl.InterleavePatternCategoryImpl;

public abstract class PatternCategoryFactory {

  public static final PatternCategory createPatternCategory(
      Name[] attributeNames, boolean hasText,
      RepeatableName[] contentRepeatableNames) {
    PatternCategory patternCategory;
    if (contentRepeatableNames.length == 0)
      patternCategory = new EmptyPatternCategory();
    else if (contentRepeatableNames.length == 1)
      patternCategory = new OptionalRepeatableElementPatternCategory();
    else try {
      patternCategory = new GroupPatternCategoryImpl();
      patternCategory.addPattern(
          attributeNames, hasText, contentRepeatableNames);
      return patternCategory;
    }
    catch (IllegalArgumentException exception) {
      patternCategory = new InterleavePatternCategoryImpl();
    }
    patternCategory.addPattern(attributeNames, hasText, contentRepeatableNames);
    return patternCategory;
  }

  public static final PatternCategory generalizePatternCategory(
      PatternCategory patternCategory) {
    if (patternCategory instanceof OptionalRepeatableElementPatternCategory)
      return new GroupPatternCategoryImpl(
          (ChoicePatternCategory)patternCategory,
          ((OptionalRepeatableElementPatternCategory)patternCategory).
          attributesPatternCategory(),
          ((OptionalRepeatableElementPatternCategory)patternCategory).
          hasText());
    if (patternCategory instanceof GroupPatternCategoryImpl)
      return new InterleavePatternCategoryImpl(
          (GroupPatternCategory)patternCategory,
          ((GroupPatternCategoryImpl)patternCategory).
          attributesPatternCategory(),
          ((GroupPatternCategoryImpl)patternCategory).hasText());
    throw new IllegalArgumentException();
  }

  public static final PatternCategory addPatternToPatternCategory(
      PatternCategory patternCategory,
      Name[] attributeNames, boolean hasText,
      RepeatableName[] contentRepeatableNames)
  {
    while (!patternCategory.
           addPattern(attributeNames, hasText, contentRepeatableNames)) {
      if (patternCategory instanceof EmptyPatternCategory) {
        AttributesPatternCategory attributesPatternCategory =
            ((EmptyPatternCategory)patternCategory).
            attributesPatternCategory();
        boolean hasAlreadyText =
            ((EmptyPatternCategory)patternCategory).hasText();
        patternCategory =
            contentRepeatableNames.length == 1 ?
            (PatternCategory)new OptionalRepeatableElementPatternCategory(
            attributesPatternCategory, hasAlreadyText) :
            (PatternCategory)new GroupPatternCategoryImpl(
            attributesPatternCategory, hasAlreadyText);
      }
      else if (patternCategory instanceof
               OptionalRepeatableElementPatternCategory)
        patternCategory = new GroupPatternCategoryImpl(
            (ChoicePatternCategory)patternCategory,
            ((OptionalRepeatableElementPatternCategory)patternCategory).
            attributesPatternCategory(),
            ((OptionalRepeatableElementPatternCategory)patternCategory).
            hasText());
      else if (patternCategory instanceof GroupPatternCategoryImpl)
        patternCategory = new InterleavePatternCategoryImpl(
            (GroupPatternCategory)patternCategory,
            ((GroupPatternCategoryImpl)patternCategory).
            attributesPatternCategory(),
            ((GroupPatternCategoryImpl)patternCategory).hasText());
      else
        throw new IllegalArgumentException();
    }
    return patternCategory;
  }
}
