/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package base.table;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 *
 * @author illi
 */
public class DynamicTableCellRenderer extends JLabel implements TableCellRenderer{

    
    /** 
     * Konstruktor - Vytvori novu instanciu triedy
     * 
     */
    public DynamicTableCellRenderer() {
        super();
        setOpaque(true);
        setHorizontalAlignment(JLabel.CENTER);
    }

    /**
     * Implementuje metodu pomocou ktorej sa nastavφ vykres╡ovan² komponent
     * 
     * @param table tabulka do ktorej sa vykresluje
     * @param value text ktory sa zapise
     * @param isSelected nastavuje ci dana bunka je/nie je oznacena
     * @param hasFocus nastavuje ci dana bunka ma/nema focus
     * @param row index riadka do ktoreho sa zapisuje
     * @param column index stσpca do ktoreho sa zapisuje
     * @return vracia vytvoreny komponent = text ktory sa zobrazi v bunke
     */
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        
        setText((String)value);
        setBackground(new java.awt.Color(255, 255, 255));
        
        return this;
    }
    
}

