/*
 * The_xmloperator_project Software License, Version 1.7
 *
 * Copyright (c) 2000 - 2003 The_xmloperator_project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *      "This product includes or uses software developped
 *       by The_xmloperator_project (http://www.xmloperator.net/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. Products derived from this software may not be called "xmloperator",
 *    nor may "xmloperator" appear in their name, without prior written
 *    permission. For written permission, please contact
 *    the xmloperator project administrator.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE_XMLOPERATOR_PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * Further information can be found on the project's site
 * (http://www.xmloperator.net/).
 */
package xmltorng.i2s.impl;

import java.util.Map;

import xmltorng.framework.document.relaxng.Name;
import xmltorng.framework.document.relaxng.Pattern;
import xmltorng.framework.document.relaxng.NonEmptyPattern;
import xmltorng.i2s.framework.RepeatableName;
import xmltorng.i2s.framework.PatternCategory;
import xmltorng.i2s.framework.ChoicePatternCategory;
import xmltorng.i2s.framework.AttributesPatternCategory;
import xmltorng.i2s.util.PatternFactory;
import xmltorng.i2s.impl.RepeatableElementPatternCategory;

/**
 * The <code>OptionalRepeatableElementPatterncategory</code> is a pattern
 *   category that contains optional or not optional choice patterns between
 *   repeatable or not repeatable named elements.
 * It may also contain attributes and/or text.
 * It may not contain only the empty pattern.
 *
 * Formally:
 * attribute ::= <attribute name="QName"> <text/> </attribute>
 * attributes ::= attribute | (<group> attribute+ </group>)
 * element ::= <element name="QName"> any </element>
 * oneOrMoreElement ::= element | (<oneOrMore> element </oneOrMore>)
 *   | (choice> (element* & (<oneOrMore> element </oneOrMore>)+) </choice>)
 * zerorOrMoreElement ::= oneOrMoreElement
 *   | (<optional> oneOrMoreElement </optional>)
 * zerorOrMoreElementAndText ::= zerorOrMoreElement
 *   | (<interleave> zerorOrMoreElement <text/> </interleave>)
 * content ::= zerorOrMoreElementAndText
 *   | (<group> attributes zerorOrMoreElementAndText </group>)
 */
public final class OptionalRepeatableElementPatternCategory
    extends RepeatableElementPatternCategory implements ChoicePatternCategory {
  private boolean isOptional = false;

  public OptionalRepeatableElementPatternCategory() {
    super();
  }

  public OptionalRepeatableElementPatternCategory(
      AttributesPatternCategory attributesPatternCategory, boolean hasText) {
    super(attributesPatternCategory, hasText);
  }

  public OptionalRepeatableElementPatternCategory(
      Name elementName, boolean isRepeatable, boolean isOptional) {
    super(elementName, isRepeatable);
    this.isOptional = isOptional;
  }

  public void setPatternOptional(boolean isOptional) {
    this.isOptional = isOptional;
  }

  /////////////////////
  // Object overloading
  /////////////////////

  public String toString() {
    return this.isOptional ? super.toString() + "?" : super.toString();
  }

  /////////////////////////////////
  // PatternCategory implementation
  /////////////////////////////////

  public Pattern fullPattern(Map fromNameToElementDefinition) {
    if (this.fromElementNameToRepeatable.size() == 0)
      return null;
    if (!this.isOptional)
      return super.fullPattern(fromNameToElementDefinition);
    NonEmptyPattern pattern = PatternFactory.choiceFromRepeatableNames(
        fromNameToElementDefinition, this.fromElementNameToRepeatable, true);
    if (this.hasText)
      pattern = PatternFactory.interleave(
          new NonEmptyPattern[] {pattern, PatternFactory.textPattern()});
    if (this.attributesPatternCategory == null)
      return pattern;
    Pattern attributesPattern = this.attributesPatternCategory.fullPattern();
    return attributesPattern.isEmpty() ? pattern :
        PatternFactory.group(
        new NonEmptyPattern[] {(NonEmptyPattern)attributesPattern, pattern});
  }

  public boolean addPattern(
      Name[] attributeNames, boolean hasText,
      RepeatableName[] repeatableElementNames) {
    if (repeatableElementNames.length == 0) {
      this.isOptional = true;
      if (hasText)
        this.hasText = true;
      this.attributesPatternCategory.addAttributeNames(attributeNames);
      return true;
    }
    else
      return super.addPattern(attributeNames, hasText, repeatableElementNames);
  }

  ///////////////////////////////////////
  // ChoicePatternCategory implementation
  ///////////////////////////////////////

  public boolean isPatternOptional() {
    return this.isOptional;
  }
}
