package convert.relaxng.input.parse.sax;

import convert.relaxng.input.parse.ParseInputFormat;
import convert.relaxng.parse.Parseable;
import convert.relaxng.parse.sax.SAXParseable;
import convert.xml.sax.XMLReaderCreator;
import convert.xml.sax.Jaxp11XMLReaderCreator;
import org.xml.sax.InputSource;
import org.xml.sax.ErrorHandler;

public class SAXParseInputFormat extends ParseInputFormat {
  private final XMLReaderCreator xrc = new Jaxp11XMLReaderCreator();

  public SAXParseInputFormat() {
    super(true);
  }

  public Parseable makeParseable(InputSource in, ErrorHandler eh) {
    return new SAXParseable(xrc, in, eh);
  }
}
