package convert.relaxng.output.xsd.basic;

import convert.relaxng.edit.SourceLocation;

public class WildcardElement extends Particle {
  private final Wildcard wildcard;

  public WildcardElement(SourceLocation location, Annotation annotation, Wildcard wildcard) {
    super(location, annotation);
    this.wildcard = wildcard;
  }

  public Wildcard getWildcard() {
    return wildcard;
  }

  public boolean equals(Object obj) {
    return super.equals(obj) && ((WildcardElement)obj).wildcard.equals(wildcard);
  }

  public int hashCode() {
    return super.hashCode() ^ wildcard.hashCode();
  }

  public <T> T accept(ParticleVisitor<T> visitor) {
    return visitor.visitWildcardElement(this);
  }
}
