package convert.datatype.xsd;

import convert.relaxng.datatype.DatatypeLibrary;
import convert.relaxng.datatype.DatatypeLibraryFactory;
import convert.xml.util.WellKnownNamespaces;

public class DatatypeLibraryFactoryImpl implements DatatypeLibraryFactory {

  private DatatypeLibrary datatypeLibrary = null;

  public DatatypeLibrary createDatatypeLibrary(String uri) {
    if (!WellKnownNamespaces.XML_SCHEMA_DATATYPES.equals(uri))
      return null;
    synchronized (this) {
      if (datatypeLibrary == null)
        datatypeLibrary = new DatatypeLibraryImpl();
      return datatypeLibrary;
    }
  }
}
