/*
 * MainWindow.java
 *
 * Created on 18. březen 2009, 11:27
 */
package base;

import base.*;
import base.tree.*;
import base.table.*;

import java.awt.*;
import javax.swing.*;
import java.net.MalformedURLException;
import java.io.IOException;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
//import kniznice dom4j na XML
import org.dom4j.*;
import xmltorng.i2s.SchemaGenerator;
import convert.relaxng.translate.Driver;


/**
 *
 * @author  illi
 */
public class MainWindow extends javax.swing.JFrame {

    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
        getContentPane().setBackground(new Color(220, 235, 255));
        this.setVisible(true);
        MainViewSplitPane.setBackground(new Color(220, 235, 255));

        // init QuitFrame
        QuitFrame = new XQuitFrame();
        QuitFrame.setVisible(false);
        QuitFrame.setLocationRelativeTo(this);

        // init AboutFrame
        AboutFrame = new XAboutFrame();
        AboutFrame.setVisible(false);
        AboutFrame.setLocationRelativeTo(this);

        // init ApplicationMessageFrame
        ApplicationMessageFrame = new XApplicationMessageFrame();
        ApplicationMessageFrame.setVisible(false);
        ApplicationMessageFrame.setLocationRelativeTo(this);

        // init PropertiesFrame
        PropertiesFrame = new XPropertiesFrame();
        PropertiesFrame.setVisible(false);
        PropertiesFrame.setLocationRelativeTo(this);
        
        // init ToolbarButtons
        ToolbarOpenFile.setEnabled(true);
        ToolbarSaveFile.setEnabled(false);
        ToolbarCloseFile.setEnabled(false);
        ToolbarOpenSchema.setEnabled(true);
        ToolbarSaveSchema.setEnabled(false);
        ToolbarCloseSchema.setEnabled(false);
        ToolbarGenerateSchema.setEnabled(false);
        ToolbarVisualize.setEnabled(false);
        ToolbarEndVisualization.setEnabled(false);
        ToolbarExportSQL.setEnabled(false);

        // init Menus
        MenuXMLOpen.setEnabled(true);
        MenuXMLSave.setEnabled(false);
        MenuXMLClose.setEnabled(false);
        MenuSchemaOpen.setEnabled(true);
        MenuSchemaSave.setEnabled(false);
        MenuSchemaClose.setEnabled(false);
        MenuSchemaGenerate.setEnabled(false);
        MenuVisualizerVisualize.setEnabled(false);
        MenuVisualizerEndVisualization.setEnabled(false);
        MenuVisualizerExportSQL.setEnabled(false);
        TabsPane.setEnabledAt(0, false);
        TabsPane.setEnabledAt(1, false);
        TabsPane.setEnabledAt(2, false);

        // disable Progressbar
        StatusProgress.setVisible(false);


        TabsPaneXMLText.setEditable(false);
        TabsPaneXMLText.setVisible(false);

        // init XMLFileChooser
        XMLFileChooser = new JFileChooser("./other/samples/");
        filterxml = new ExampleFileFilter("xml", "XML files only");
        XMLFileChooser.setFileFilter(filterxml);
        //XMLFileChooser.changeToParentDirectory();

        TabsPaneXSDText.setEditable(false);
        TabsPaneXSDText.setVisible(false);

        // init XSDFileChooser
        XSDFileChooser = new JFileChooser("./other/samples/");
        filterrng = new ExampleFileFilter("rng", "RNG files only");
        filterrnc = new ExampleFileFilter("rnc", "RNC files only");
        filterxsd = new ExampleFileFilter("xsd", "XSD files only");
        filterdtd = new ExampleFileFilter("dtd", "DTD files only");
        XSDFileChooserSetExtension(SchemaOutputFormat);
        //XSDFileChooser.changeToParentDirectory();

        // init grafika toolbaru
        Toolbar.setBackground(new Color(240, 240, 240));
        ToolbarOpenFile.setIcon(ImgToolbarXMLOpennorm);
        ToolbarOpenFile.setRolloverEnabled(true);
        ToolbarOpenFile.setRolloverIcon(ImgToolbarXMLOpenroll);
        ToolbarSaveFile.setIcon(ImgToolbarXMLSavenorm);
        ToolbarSaveFile.setRolloverEnabled(true);
        ToolbarSaveFile.setRolloverIcon(ImgToolbarXMLSaveroll);
        ToolbarCloseFile.setIcon(ImgToolbarXMLClosenorm);
        ToolbarCloseFile.setRolloverEnabled(true);
        ToolbarCloseFile.setRolloverIcon(ImgToolbarXMLCloseroll);
        ToolbarOpenSchema.setIcon(ImgToolbarXSDOpennorm);
        ToolbarOpenSchema.setRolloverEnabled(true);
        ToolbarOpenSchema.setRolloverIcon(ImgToolbarXSDOpenroll);
        ToolbarSaveSchema.setIcon(ImgToolbarXSDSavenorm);
        ToolbarSaveSchema.setRolloverEnabled(true);
        ToolbarSaveSchema.setRolloverIcon(ImgToolbarXSDSaveroll);
        ToolbarCloseSchema.setIcon(ImgToolbarXSDClosenorm);
        ToolbarCloseSchema.setRolloverEnabled(true);
        ToolbarCloseSchema.setRolloverIcon(ImgToolbarXSDCloseroll);
        ToolbarGenerateSchema.setIcon(ImgToolbarXSDGeneratenorm);
        ToolbarGenerateSchema.setRolloverEnabled(true);
        ToolbarGenerateSchema.setRolloverIcon(ImgToolbarXSDGenerateroll);
        ToolbarVisualize.setIcon(ImgToolbarVisualizenorm);
        ToolbarVisualize.setRolloverEnabled(true);
        ToolbarVisualize.setRolloverIcon(ImgToolbarVisualizeroll);
        ToolbarEndVisualization.setIcon(ImgToolbarEndVisualizenorm);
        ToolbarEndVisualization.setRolloverEnabled(true);
        ToolbarEndVisualization.setRolloverIcon(ImgToolbarEndVisualizeroll);
        ToolbarExportSQL.setIcon(ImgToolbarExportSQLnorm);
        ToolbarExportSQL.setRolloverEnabled(true);
        ToolbarExportSQL.setRolloverIcon(ImgToolbarExportSQLroll);
        
        // init grafika menu
        MenuXMLOpen.setIcon(ImgMenuXMLOpennorm);
        MenuXMLSave.setIcon(ImgMenuXMLSavenorm);
        MenuXMLClose.setIcon(ImgMenuXMLClosenorm);
        MenuSchemaOpen.setIcon(ImgMenuXSDOpennorm);
        MenuSchemaSave.setIcon(ImgMenuXSDSavenorm);
        MenuSchemaClose.setIcon(ImgMenuXSDClosenorm);
        MenuSchemaGenerate.setIcon(ImgMenuXSDGeneratenorm);
        MenuVisualizerVisualize.setIcon(ImgMenuVisualizerVisualizenorm);
        MenuVisualizerEndVisualization.setIcon(ImgMenuVisualizerEndVisualizenorm);
        MenuVisualizerExportSQL.setIcon(ImgMenuVisualizerExportSQLnorm);
        MenuFileProperties.setIcon(ImgMenuFilePropertiesnorm);
        MenuFileExit.setIcon(ImgMenuFileExitnorm);
        MenuHelpHelp.setIcon(ImgMenuHelpHelpnorm);
        MenuHelpDocumentation.setIcon(ImgMenuHelpDocnorm);
        MenuHelpAbout.setIcon(ImgMenuHelpAboutnorm);

        //ScrollPaneTreeView.removeAll();
        generatedTree = new XMLTree();
        TreeView = new JTree();
        
        MainViewSplitPane.setDividerLocation(0);
        MainViewSplitPane.setEnabled(false);
        
        try {
            XMLHandler.loadConfig();
        } catch (DocumentException ex) {
            //ShowMessage("ERROR!", "Error has occured while loading config!");
        }
        SetDisplayMode();
        ApplyConfigChanges();
        XSDFileChooserSetExtension(SchemaOutputFormat);

        Convertor = new Driver();
        Generator = new SchemaGenerator();
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {

        Toolbar = new javax.swing.JToolBar();
        ToolbarOpenFile = new javax.swing.JButton();
        ToolbarSaveFile = new javax.swing.JButton();
        ToolbarCloseFile = new javax.swing.JButton();
        ToolbarSeparator1 = new javax.swing.JToolBar.Separator();
        ToolbarOpenSchema = new javax.swing.JButton();
        ToolbarSaveSchema = new javax.swing.JButton();
        ToolbarCloseSchema = new javax.swing.JButton();
        ToolbarGenerateSchema = new javax.swing.JButton();
        ToolbarSeparator2 = new javax.swing.JToolBar.Separator();
        ToolbarVisualize = new javax.swing.JButton();
        ToolbarEndVisualization = new javax.swing.JButton();
        ToolbarExportSQL = new javax.swing.JButton();
        StatusPanel = new javax.swing.JPanel();
        StatusText = new javax.swing.JLabel();
        StatusProgress = new javax.swing.JProgressBar();
        MainViewSplitPane = new javax.swing.JSplitPane();
        ScrollPaneTreeView = new javax.swing.JScrollPane();
        TabsPane = new javax.swing.JTabbedPane();
        TabsPaneXML = new javax.swing.JPanel();
        TabsPaneXMLScrollPane = new javax.swing.JScrollPane();
        TabsPaneXMLText = new javax.swing.JTextArea();
        TabsPaneXDS = new javax.swing.JPanel();
        TabsPaneXSDSrollPane = new javax.swing.JScrollPane();
        TabsPaneXSDText = new javax.swing.JTextArea();
        TabsPaneTables = new javax.swing.JPanel();
        VisualizeTabsPane = new javax.swing.JTabbedPane();
        Menu = new javax.swing.JMenuBar();
        MenuFile = new javax.swing.JMenu();
        MenuFileProperties = new javax.swing.JMenuItem();
        MenuFileExit = new javax.swing.JMenuItem();
        MenuXML = new javax.swing.JMenu();
        MenuXMLOpen = new javax.swing.JMenuItem();
        MenuXMLSave = new javax.swing.JMenuItem();
        MenuXMLClose = new javax.swing.JMenuItem();
        MenuSchema = new javax.swing.JMenu();
        MenuSchemaOpen = new javax.swing.JMenuItem();
        MenuSchemaSave = new javax.swing.JMenuItem();
        MenuSchemaClose = new javax.swing.JMenuItem();
        MenuSchemaGenerate = new javax.swing.JMenuItem();
        MenuVisualizer = new javax.swing.JMenu();
        MenuVisualizerVisualize = new javax.swing.JMenuItem();
        MenuVisualizerEndVisualization = new javax.swing.JMenuItem();
        MenuVisualizerExportSQL = new javax.swing.JMenuItem();
        MenuHelp = new javax.swing.JMenu();
        MenuHelpHelp = new javax.swing.JMenuItem();
        MenuHelpDocumentation = new javax.swing.JMenuItem();
        MenuHelpAbout = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("XMLspark");
        setMaximizedBounds(new java.awt.Rectangle(0, 0, 1600, 1200));
        setMinimumSize(new java.awt.Dimension(850, 600));
        setName("MainWindow"); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        Toolbar.setFloatable(false);
        Toolbar.setMargin(new java.awt.Insets(0, 5, 0, 5));
        Toolbar.setMaximumSize(new java.awt.Dimension(2000, 54));
        Toolbar.setMinimumSize(new java.awt.Dimension(808, 54));
        Toolbar.setName("Toolbar"); // NOI18N
        Toolbar.setPreferredSize(new java.awt.Dimension(900, 54));

        ToolbarOpenFile.setToolTipText("Open XML Document");
        ToolbarOpenFile.setBorderPainted(false);
        ToolbarOpenFile.setContentAreaFilled(false);
        ToolbarOpenFile.setFocusable(false);
        ToolbarOpenFile.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarOpenFile.setIconTextGap(0);
        ToolbarOpenFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarOpenFile.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarOpenFile.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarOpenFile.setName("ToolbarOpenFile"); // NOI18N
        ToolbarOpenFile.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarOpenFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarOpenFileActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarOpenFile);

        ToolbarSaveFile.setToolTipText("Save XML Document");
        ToolbarSaveFile.setBorderPainted(false);
        ToolbarSaveFile.setContentAreaFilled(false);
        ToolbarSaveFile.setFocusable(false);
        ToolbarSaveFile.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarSaveFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarSaveFile.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarSaveFile.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarSaveFile.setName("ToolbarSaveFile"); // NOI18N
        ToolbarSaveFile.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarSaveFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarSaveFileActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarSaveFile);

        ToolbarCloseFile.setToolTipText("Close XML Document");
        ToolbarCloseFile.setBorderPainted(false);
        ToolbarCloseFile.setContentAreaFilled(false);
        ToolbarCloseFile.setFocusable(false);
        ToolbarCloseFile.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarCloseFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarCloseFile.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarCloseFile.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarCloseFile.setName("ToolbarCloseFile"); // NOI18N
        ToolbarCloseFile.setPreferredSize(new java.awt.Dimension(48, 48));
        ToolbarCloseFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarCloseFileActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarCloseFile);

        ToolbarSeparator1.setEnabled(false);
        ToolbarSeparator1.setName("ToolbarSeparator1"); // NOI18N
        ToolbarSeparator1.setSeparatorSize(new java.awt.Dimension(15, 50));
        Toolbar.add(ToolbarSeparator1);

        ToolbarOpenSchema.setToolTipText("Open XML Schema");
        ToolbarOpenSchema.setBorderPainted(false);
        ToolbarOpenSchema.setContentAreaFilled(false);
        ToolbarOpenSchema.setFocusable(false);
        ToolbarOpenSchema.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarOpenSchema.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarOpenSchema.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarOpenSchema.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarOpenSchema.setName("ToolbarOpenSchema"); // NOI18N
        ToolbarOpenSchema.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarOpenSchema.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarOpenSchemaActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarOpenSchema);

        ToolbarSaveSchema.setToolTipText("Save XML Schema");
        ToolbarSaveSchema.setBorderPainted(false);
        ToolbarSaveSchema.setContentAreaFilled(false);
        ToolbarSaveSchema.setFocusable(false);
        ToolbarSaveSchema.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarSaveSchema.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarSaveSchema.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarSaveSchema.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarSaveSchema.setName("ToolbarSaveSchema"); // NOI18N
        ToolbarSaveSchema.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarSaveSchema.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarSaveSchemaActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarSaveSchema);

        ToolbarCloseSchema.setToolTipText("Close XML Schema");
        ToolbarCloseSchema.setBorderPainted(false);
        ToolbarCloseSchema.setContentAreaFilled(false);
        ToolbarCloseSchema.setFocusable(false);
        ToolbarCloseSchema.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarCloseSchema.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarCloseSchema.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarCloseSchema.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarCloseSchema.setName("ToolbarCloseSchema"); // NOI18N
        ToolbarCloseSchema.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarCloseSchema.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarCloseSchemaActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarCloseSchema);

        ToolbarGenerateSchema.setToolTipText("Generate XML Schema");
        ToolbarGenerateSchema.setBorderPainted(false);
        ToolbarGenerateSchema.setContentAreaFilled(false);
        ToolbarGenerateSchema.setFocusable(false);
        ToolbarGenerateSchema.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarGenerateSchema.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarGenerateSchema.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarGenerateSchema.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarGenerateSchema.setName("ToolbarGenerateSchema"); // NOI18N
        ToolbarGenerateSchema.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarGenerateSchema.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarGenerateSchemaActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarGenerateSchema);

        ToolbarSeparator2.setName("ToolbarSeparator2"); // NOI18N
        ToolbarSeparator2.setSeparatorSize(new java.awt.Dimension(15, 50));
        Toolbar.add(ToolbarSeparator2);

        ToolbarVisualize.setToolTipText("Visualize");
        ToolbarVisualize.setBorderPainted(false);
        ToolbarVisualize.setContentAreaFilled(false);
        ToolbarVisualize.setFocusable(false);
        ToolbarVisualize.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarVisualize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarVisualize.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarVisualize.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarVisualize.setName("ToolbarVisualize"); // NOI18N
        ToolbarVisualize.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarVisualize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarVisualizeActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarVisualize);

        ToolbarEndVisualization.setToolTipText("End Visualization");
        ToolbarEndVisualization.setBorderPainted(false);
        ToolbarEndVisualization.setContentAreaFilled(false);
        ToolbarEndVisualization.setFocusable(false);
        ToolbarEndVisualization.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarEndVisualization.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarEndVisualization.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarEndVisualization.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarEndVisualization.setName("ToolbarEndVisualization"); // NOI18N
        ToolbarEndVisualization.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarEndVisualization.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarEndVisualizationActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarEndVisualization);

        ToolbarExportSQL.setToolTipText("Export to SQL");
        ToolbarExportSQL.setBorderPainted(false);
        ToolbarExportSQL.setContentAreaFilled(false);
        ToolbarExportSQL.setFocusable(false);
        ToolbarExportSQL.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        ToolbarExportSQL.setMargin(new java.awt.Insets(0, 0, 0, 0));
        ToolbarExportSQL.setMaximumSize(new java.awt.Dimension(54, 54));
        ToolbarExportSQL.setMinimumSize(new java.awt.Dimension(54, 54));
        ToolbarExportSQL.setName("ToolbarExportSQL"); // NOI18N
        ToolbarExportSQL.setPreferredSize(new java.awt.Dimension(54, 54));
        ToolbarExportSQL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ToolbarExportSQLActionPerformed(evt);
            }
        });
        Toolbar.add(ToolbarExportSQL);

        StatusPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED));
        StatusPanel.setName("StatusPanel"); // NOI18N

        StatusText.setText("Ready.");
        StatusText.setName("StatusText"); // NOI18N

        StatusProgress.setToolTipText("");
        StatusProgress.setName("StatusProgress"); // NOI18N

        javax.swing.GroupLayout StatusPanelLayout = new javax.swing.GroupLayout(StatusPanel);
        StatusPanel.setLayout(StatusPanelLayout);
        StatusPanelLayout.setHorizontalGroup(
            StatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(StatusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(StatusText, javax.swing.GroupLayout.PREFERRED_SIZE, 512, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 166, Short.MAX_VALUE)
                .addComponent(StatusProgress, javax.swing.GroupLayout.PREFERRED_SIZE, 208, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        StatusPanelLayout.setVerticalGroup(
            StatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(StatusText, javax.swing.GroupLayout.DEFAULT_SIZE, 18, Short.MAX_VALUE)
            .addComponent(StatusProgress, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        MainViewSplitPane.setBorder(null);
        MainViewSplitPane.setDividerLocation(200);
        MainViewSplitPane.setDividerSize(4);
        MainViewSplitPane.setName("MainViewSplitPane"); // NOI18N

        ScrollPaneTreeView.setName("ScrollPaneTreeView"); // NOI18N
        MainViewSplitPane.setLeftComponent(ScrollPaneTreeView);

        TabsPane.setName("TabsPane"); // NOI18N
        TabsPane.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                TabsPaneStateChanged(evt);
            }
        });

        TabsPaneXML.setName("TabsPaneXML"); // NOI18N

        TabsPaneXMLScrollPane.setName("TabsPaneXMLScrollPane"); // NOI18N

        TabsPaneXMLText.setColumns(20);
        TabsPaneXMLText.setFont(new java.awt.Font("Courier New", 0, 12));
        TabsPaneXMLText.setRows(5);
        TabsPaneXMLText.setName("TabsPaneXMLText"); // NOI18N
        TabsPaneXMLScrollPane.setViewportView(TabsPaneXMLText);

        javax.swing.GroupLayout TabsPaneXMLLayout = new javax.swing.GroupLayout(TabsPaneXML);
        TabsPaneXML.setLayout(TabsPaneXMLLayout);
        TabsPaneXMLLayout.setHorizontalGroup(
            TabsPaneXMLLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(TabsPaneXMLScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 671, Short.MAX_VALUE)
        );
        TabsPaneXMLLayout.setVerticalGroup(
            TabsPaneXMLLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(TabsPaneXMLScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 460, Short.MAX_VALUE)
        );

        TabsPane.addTab("XML document", TabsPaneXML);

        TabsPaneXDS.setName("TabsPaneXDS"); // NOI18N

        TabsPaneXSDSrollPane.setName("TabsPaneXSDSrollPane"); // NOI18N

        TabsPaneXSDText.setColumns(20);
        TabsPaneXSDText.setFont(new java.awt.Font("Lucida Console", 0, 13));
        TabsPaneXSDText.setForeground(new java.awt.Color(0, 80, 0));
        TabsPaneXSDText.setRows(5);
        TabsPaneXSDText.setName("TabsPaneXSDText"); // NOI18N
        TabsPaneXSDSrollPane.setViewportView(TabsPaneXSDText);

        javax.swing.GroupLayout TabsPaneXDSLayout = new javax.swing.GroupLayout(TabsPaneXDS);
        TabsPaneXDS.setLayout(TabsPaneXDSLayout);
        TabsPaneXDSLayout.setHorizontalGroup(
            TabsPaneXDSLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(TabsPaneXSDSrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 671, Short.MAX_VALUE)
        );
        TabsPaneXDSLayout.setVerticalGroup(
            TabsPaneXDSLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(TabsPaneXSDSrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 460, Short.MAX_VALUE)
        );

        TabsPane.addTab("XML Shema", TabsPaneXDS);

        TabsPaneTables.setName("TabsPaneTables"); // NOI18N

        VisualizeTabsPane.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        VisualizeTabsPane.setName("VisualizeTabsPane"); // NOI18N

        javax.swing.GroupLayout TabsPaneTablesLayout = new javax.swing.GroupLayout(TabsPaneTables);
        TabsPaneTables.setLayout(TabsPaneTablesLayout);
        TabsPaneTablesLayout.setHorizontalGroup(
            TabsPaneTablesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(VisualizeTabsPane, javax.swing.GroupLayout.DEFAULT_SIZE, 671, Short.MAX_VALUE)
        );
        TabsPaneTablesLayout.setVerticalGroup(
            TabsPaneTablesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(VisualizeTabsPane, javax.swing.GroupLayout.DEFAULT_SIZE, 460, Short.MAX_VALUE)
        );

        TabsPane.addTab("Visualizer", TabsPaneTables);

        MainViewSplitPane.setRightComponent(TabsPane);

        Menu.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        Menu.setName("Menu"); // NOI18N

        MenuFile.setText("File");
        MenuFile.setName("MenuFile"); // NOI18N

        MenuFileProperties.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_P, java.awt.event.InputEvent.CTRL_MASK));
        MenuFileProperties.setBackground(new java.awt.Color(255, 255, 255));
        MenuFileProperties.setText("Properties");
        MenuFileProperties.setName("MenuFileProperties"); // NOI18N
        MenuFileProperties.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuFilePropertiesMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuFilePropertiesMouseExited(evt);
            }
        });
        MenuFileProperties.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuFilePropertiesActionPerformed(evt);
            }
        });
        MenuFile.add(MenuFileProperties);

        MenuFileExit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK));
        MenuFileExit.setBackground(new java.awt.Color(255, 255, 255));
        MenuFileExit.setText("Exit");
        MenuFileExit.setName("MenuFileExit"); // NOI18N
        MenuFileExit.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuFileExitMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuFileExitMouseExited(evt);
            }
        });
        MenuFileExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuFileExitActionPerformed(evt);
            }
        });
        MenuFile.add(MenuFileExit);

        Menu.add(MenuFile);

        MenuXML.setText("XML Document");
        MenuXML.setName("MenuXML"); // NOI18N

        MenuXMLOpen.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
        MenuXMLOpen.setBackground(new java.awt.Color(255, 255, 255));
        MenuXMLOpen.setText("Open Document");
        MenuXMLOpen.setName("MenuXMLOpen"); // NOI18N
        MenuXMLOpen.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuXMLOpenMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuXMLOpenMouseExited(evt);
            }
        });
        MenuXMLOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuXMLOpenActionPerformed(evt);
            }
        });
        MenuXML.add(MenuXMLOpen);

        MenuXMLSave.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        MenuXMLSave.setBackground(new java.awt.Color(255, 255, 255));
        MenuXMLSave.setText("Save Document");
        MenuXMLSave.setName("MenuXMLSave"); // NOI18N
        MenuXMLSave.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuXMLSaveMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuXMLSaveMouseExited(evt);
            }
        });
        MenuXMLSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuXMLSaveActionPerformed(evt);
            }
        });
        MenuXML.add(MenuXMLSave);

        MenuXMLClose.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_W, java.awt.event.InputEvent.CTRL_MASK));
        MenuXMLClose.setBackground(new java.awt.Color(255, 255, 255));
        MenuXMLClose.setText("Close Document");
        MenuXMLClose.setName("MenuXMLClose"); // NOI18N
        MenuXMLClose.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuXMLCloseMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuXMLCloseMouseExited(evt);
            }
        });
        MenuXMLClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuXMLCloseActionPerformed(evt);
            }
        });
        MenuXML.add(MenuXMLClose);

        Menu.add(MenuXML);

        MenuSchema.setText("XML Schema");
        MenuSchema.setName("MenuSchema"); // NOI18N

        MenuSchemaOpen.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.ALT_MASK));
        MenuSchemaOpen.setBackground(new java.awt.Color(255, 255, 255));
        MenuSchemaOpen.setText("Open Schema");
        MenuSchemaOpen.setName("MenuSchemaOpen"); // NOI18N
        MenuSchemaOpen.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuSchemaOpenMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuSchemaOpenMouseExited(evt);
            }
        });
        MenuSchemaOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuSchemaOpenActionPerformed(evt);
            }
        });
        MenuSchema.add(MenuSchemaOpen);

        MenuSchemaSave.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.ALT_MASK));
        MenuSchemaSave.setBackground(new java.awt.Color(255, 255, 255));
        MenuSchemaSave.setText("Save Schema");
        MenuSchemaSave.setName("MenuSchemaSave"); // NOI18N
        MenuSchemaSave.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuSchemaSaveMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuSchemaSaveMouseExited(evt);
            }
        });
        MenuSchemaSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuSchemaSaveActionPerformed(evt);
            }
        });
        MenuSchema.add(MenuSchemaSave);

        MenuSchemaClose.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_W, java.awt.event.InputEvent.ALT_MASK));
        MenuSchemaClose.setBackground(new java.awt.Color(255, 255, 255));
        MenuSchemaClose.setText("Close Schema");
        MenuSchemaClose.setName("MenuSchemaClose"); // NOI18N
        MenuSchemaClose.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuSchemaCloseMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuSchemaCloseMouseExited(evt);
            }
        });
        MenuSchemaClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuSchemaCloseActionPerformed(evt);
            }
        });
        MenuSchema.add(MenuSchemaClose);

        MenuSchemaGenerate.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_G, java.awt.event.InputEvent.ALT_MASK));
        MenuSchemaGenerate.setBackground(new java.awt.Color(255, 255, 255));
        MenuSchemaGenerate.setText("Generate Schema");
        MenuSchemaGenerate.setName("MenuSchemaGenerate"); // NOI18N
        MenuSchemaGenerate.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuSchemaGenerateMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuSchemaGenerateMouseExited(evt);
            }
        });
        MenuSchemaGenerate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuSchemaGenerateActionPerformed(evt);
            }
        });
        MenuSchema.add(MenuSchemaGenerate);

        Menu.add(MenuSchema);

        MenuVisualizer.setText("Visualizer");
        MenuVisualizer.setName("MenuVisualizer"); // NOI18N

        MenuVisualizerVisualize.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1, java.awt.event.InputEvent.CTRL_MASK));
        MenuVisualizerVisualize.setBackground(new java.awt.Color(255, 255, 255));
        MenuVisualizerVisualize.setText("Visualize");
        MenuVisualizerVisualize.setName("MenuVisualizerVisualize"); // NOI18N
        MenuVisualizerVisualize.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuVisualizerVisualizeMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuVisualizerVisualizeMouseExited(evt);
            }
        });
        MenuVisualizerVisualize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuVisualizerVisualizeActionPerformed(evt);
            }
        });
        MenuVisualizer.add(MenuVisualizerVisualize);

        MenuVisualizerEndVisualization.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F2, java.awt.event.InputEvent.CTRL_MASK));
        MenuVisualizerEndVisualization.setBackground(new java.awt.Color(255, 255, 255));
        MenuVisualizerEndVisualization.setText("End Visualization");
        MenuVisualizerEndVisualization.setName("MenuVisualizerEndVisualization"); // NOI18N
        MenuVisualizerEndVisualization.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuVisualizerEndVisualizationMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuVisualizerEndVisualizationMouseExited(evt);
            }
        });
        MenuVisualizerEndVisualization.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuVisualizerEndVisualizationActionPerformed(evt);
            }
        });
        MenuVisualizer.add(MenuVisualizerEndVisualization);

        MenuVisualizerExportSQL.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F3, java.awt.event.InputEvent.CTRL_MASK));
        MenuVisualizerExportSQL.setBackground(new java.awt.Color(255, 255, 255));
        MenuVisualizerExportSQL.setText("Export to SQL");
        MenuVisualizerExportSQL.setName("MenuVisualizerExportSQL"); // NOI18N
        MenuVisualizerExportSQL.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuVisualizerExportSQLMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuVisualizerExportSQLMouseExited(evt);
            }
        });
        MenuVisualizerExportSQL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuVisualizerExportSQLActionPerformed(evt);
            }
        });
        MenuVisualizer.add(MenuVisualizerExportSQL);

        Menu.add(MenuVisualizer);

        MenuHelp.setText("Help");
        MenuHelp.setName("MenuHelp"); // NOI18N

        MenuHelpHelp.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1, 0));
        MenuHelpHelp.setBackground(new java.awt.Color(255, 255, 255));
        MenuHelpHelp.setText("Help Contents");
        MenuHelpHelp.setName("MenuHelpHelp"); // NOI18N
        MenuHelpHelp.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuHelpHelpMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuHelpHelpMouseExited(evt);
            }
        });
        MenuHelpHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuHelpHelpActionPerformed(evt);
            }
        });
        MenuHelp.add(MenuHelpHelp);

        MenuHelpDocumentation.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1, java.awt.event.InputEvent.SHIFT_MASK));
        MenuHelpDocumentation.setBackground(new java.awt.Color(255, 255, 255));
        MenuHelpDocumentation.setText("Documentation");
        MenuHelpDocumentation.setName("MenuHelpDocumentation"); // NOI18N
        MenuHelpDocumentation.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuHelpDocumentationMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuHelpDocumentationMouseExited(evt);
            }
        });
        MenuHelpDocumentation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuHelpDocumentationActionPerformed(evt);
            }
        });
        MenuHelp.add(MenuHelpDocumentation);

        MenuHelpAbout.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F2, 0));
        MenuHelpAbout.setBackground(new java.awt.Color(255, 255, 255));
        MenuHelpAbout.setText("About");
        MenuHelpAbout.setName("MenuHelpAbout"); // NOI18N
        MenuHelpAbout.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MenuHelpAboutMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                MenuHelpAboutMouseExited(evt);
            }
        });
        MenuHelpAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MenuHelpAboutActionPerformed(evt);
            }
        });
        MenuHelp.add(MenuHelpAbout);

        Menu.add(MenuHelp);

        setJMenuBar(Menu);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(StatusPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(Toolbar, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 900, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(MainViewSplitPane, javax.swing.GroupLayout.DEFAULT_SIZE, 880, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(Toolbar, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(MainViewSplitPane, javax.swing.GroupLayout.DEFAULT_SIZE, 488, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(StatusPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>

    /**
     * Metóda ktorá zneplatní hlavné okno
     * 
     */
    public static void DisableMainWindow() {
        MainWindow.setEnabled(false);
        MainWindow.setFocusable(false);
    }

    /**
     * Metóda ktorá povolí hlavné okno a nastaví naň focus
     * 
     */
    public static void EnableMainWindow() {
        MainWindow.setEnabled(true);
        MainWindow.setFocusable(true);
        MainWindow.requestFocus(true);
    }

    /**
     * Metoda ktora sa vola kliknuti na Menu->File->Exit
     * 
     */
private void MenuFileExitActionPerformed(java.awt.event.ActionEvent evt) {                                             
    DisableMainWindow();
    QuitFrame.setLocationRelativeTo(this);
    QuitFrame.setVisible(true);
}                                            

    /**
     * Metoda ktora sa vola pri pokuse zariet Hlavne okno
     * 
     */
private void formWindowClosing(java.awt.event.WindowEvent evt) {                                   
    DisableMainWindow();
    QuitFrame.setLocationRelativeTo(this);
    QuitFrame.setVisible(true);
}                                  

    /**
     * Metoda ktora sa vola kliknutim na Menu->Help->Help Contents - zobrazi strucnu napovedu
     * 
     */
private void MenuHelpHelpActionPerformed(java.awt.event.ActionEvent evt) {                                             
    helpContents = new HelpContents(HelpPath);
    helpContents.Open();
}                                            

    /**
     * Metoda ktora sa vola kliknutim na Menu->Help->About - zobrazi popis aplikacie
     * 
     */
private void MenuHelpAboutActionPerformed(java.awt.event.ActionEvent evt) {                                              
    DisableMainWindow();
    AboutFrame.setLocationRelativeTo(this);
    AboutFrame.setVisible(true);
}                                             

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Open XML File
     * 
     */
private void ToolbarOpenFileActionPerformed(java.awt.event.ActionEvent evt) {                                                
    XMLOpen();
}                                               

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Document->Open Document
     * 
     */
private void MenuXMLOpenActionPerformed(java.awt.event.ActionEvent evt) {                                            
    XMLOpen();
}                                           

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Save XML File
     * 
     */
private void ToolbarSaveFileActionPerformed(java.awt.event.ActionEvent evt) {                                                
    XMLSave();
}                                               

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Document->Save Document
     * 
     */
private void MenuXMLSaveActionPerformed(java.awt.event.ActionEvent evt) {                                            
    XMLSave();
}                                           

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Close XML File
     * 
     */
private void ToolbarCloseFileActionPerformed(java.awt.event.ActionEvent evt) {                                                 
    XMLClose();
}                                                

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Document->Close Document
     * 
     */
private void MenuXMLCloseActionPerformed(java.awt.event.ActionEvent evt) {                                             
    XMLClose();
}                                            

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Open XML Schema
     * 
     */
private void ToolbarOpenSchemaActionPerformed(java.awt.event.ActionEvent evt) {                                                  
    XSDOpen();
}                                                 

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Schema->Open Schema
     * 
     */
private void MenuSchemaOpenActionPerformed(java.awt.event.ActionEvent evt) {                                               
    XSDOpen();
}                                              

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Save XML Schema
     * 
     */
private void ToolbarSaveSchemaActionPerformed(java.awt.event.ActionEvent evt) {                                                  
    XSDSave();
}                                                 

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Schema->Save Schema
     * 
     */
private void MenuSchemaSaveActionPerformed(java.awt.event.ActionEvent evt) {                                               
    XSDSave();
}                                              

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Close XML Schema
     * 
     */
private void ToolbarCloseSchemaActionPerformed(java.awt.event.ActionEvent evt) {                                                   
    XSDClose();
}                                                  

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Schema->Close Schema
     * 
     */
private void MenuSchemaCloseActionPerformed(java.awt.event.ActionEvent evt) {                                                
    XSDClose();
}                                               

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Generate XML Schema
     * 
     */
private void ToolbarGenerateSchemaActionPerformed(java.awt.event.ActionEvent evt) {                                                      
    Generate();
}                                                     

    /**
     * Metoda ktora sa vola kliknuti na Menu->XML Schema->Generate Schema
     * 
     */
private void MenuSchemaGenerateActionPerformed(java.awt.event.ActionEvent evt) {                                                   
    Generate();
}                                                  

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Visualize
     * 
     */
private void ToolbarVisualizeActionPerformed(java.awt.event.ActionEvent evt) {                                                 
    Visualize();
}                                                

    /**
     * Metoda ktora sa vola kliknuti na Menu->Visualizer->Visualize
     * 
     */
private void MenuVisualizerVisualizeActionPerformed(java.awt.event.ActionEvent evt) {                                                        
    Visualize();
}                                                       

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Export to XML
     * 
     */
private void ToolbarEndVisualizationActionPerformed(java.awt.event.ActionEvent evt) {                                                        
    XMLClose();
    if (!XMLdocOpened && !XSDdocOpened && !XSDdocGenerated) {
        SetDisplayMode();
    }
}                                                       

    /**
     * Metoda ktora sa vola kliknuti na Menu->Visualizer->Export to XML
     * 
     */
private void MenuVisualizerEndVisualizationActionPerformed(java.awt.event.ActionEvent evt) {                                                               
    XMLClose();
    if (!XMLdocOpened && !XSDdocOpened && !XSDdocGenerated) {
        SetDisplayMode();
    }
}                                                              

    /**
     * Metoda ktora sa vola kliknuti na Toolbar->Export to SQL
     * 
     */
private void ToolbarExportSQLActionPerformed(java.awt.event.ActionEvent evt) {                                                 
    ShowMessage("MESSAGE", "This function has not been implemented yet!");
}                                                

    /**
     * Metoda ktora sa vola kliknuti na Menu->Visualizer->Export to XML
     * 
     */
private void MenuVisualizerExportSQLActionPerformed(java.awt.event.ActionEvent evt) {                                                        
    ShowMessage("MESSAGE", "This function has not been implemented yet!");
}                                                       

/**
 * Metoda ktora meni grafiku zaloziek TABPane
 *
 * @param evt
 */
private void TabsPaneStateChanged(javax.swing.event.ChangeEvent evt) {                                      
    if (TabsPanelastSelectedIndex != -1) {
        TabsPane.setForegroundAt(TabsPanelastSelectedIndex, TabsPaneNormalForeground);
    }
    int si = TabsPane.getSelectedIndex();
    TabsPane.setForegroundAt(si, TabsPaneSelectedForeground);
    TabsPanelastSelectedIndex = si;
}                                     


// =====   START: blok mouseover grafickych zmien
private void MenuXMLOpenMouseEntered(java.awt.event.MouseEvent evt) {                                         
    if (MenuXMLOpen.isEnabled())
        MenuXMLOpen.setIcon(ImgMenuXMLOpenroll);
}                                        

private void MenuXMLOpenMouseExited(java.awt.event.MouseEvent evt) {                                        
    if (MenuXMLOpen.isEnabled())
        MenuXMLOpen.setIcon(ImgMenuXMLOpennorm);
}                                       

private void MenuXMLSaveMouseEntered(java.awt.event.MouseEvent evt) {                                         
    if (MenuXMLSave.isEnabled())
        MenuXMLSave.setIcon(ImgMenuXMLSaveroll);
}                                        

private void MenuXMLSaveMouseExited(java.awt.event.MouseEvent evt) {                                        
    if (MenuXMLSave.isEnabled())
        MenuXMLSave.setIcon(ImgMenuXMLSavenorm);
}                                       

private void MenuXMLCloseMouseEntered(java.awt.event.MouseEvent evt) {                                          
    if (MenuXMLClose.isEnabled())
        MenuXMLClose.setIcon(ImgMenuXMLCloseroll);
}                                         

private void MenuXMLCloseMouseExited(java.awt.event.MouseEvent evt) {                                         
    if (MenuXMLClose.isEnabled())
        MenuXMLClose.setIcon(ImgMenuXMLClosenorm);
}                                        

private void MenuSchemaOpenMouseEntered(java.awt.event.MouseEvent evt) {                                            
    if (MenuSchemaOpen.isEnabled())
        MenuSchemaOpen.setIcon(ImgMenuXSDOpenroll);
}                                           

private void MenuSchemaOpenMouseExited(java.awt.event.MouseEvent evt) {                                           
    if (MenuSchemaOpen.isEnabled())
        MenuSchemaOpen.setIcon(ImgMenuXSDOpennorm);
}                                          

private void MenuSchemaSaveMouseEntered(java.awt.event.MouseEvent evt) {                                            
    if (MenuSchemaSave.isEnabled())
        MenuSchemaSave.setIcon(ImgMenuXSDSaveroll);
}                                           

private void MenuSchemaSaveMouseExited(java.awt.event.MouseEvent evt) {                                           
    if (MenuSchemaSave.isEnabled())
        MenuSchemaSave.setIcon(ImgMenuXSDSavenorm);
}                                          

private void MenuSchemaCloseMouseEntered(java.awt.event.MouseEvent evt) {                                             
    if (MenuSchemaClose.isEnabled())
        MenuSchemaClose.setIcon(ImgMenuXSDCloseroll);
}                                            

private void MenuSchemaCloseMouseExited(java.awt.event.MouseEvent evt) {                                            
    if (MenuSchemaClose.isEnabled())
        MenuSchemaClose.setIcon(ImgMenuXSDClosenorm);
}                                           

private void MenuSchemaGenerateMouseEntered(java.awt.event.MouseEvent evt) {                                                
    if (MenuSchemaGenerate.isEnabled())
        MenuSchemaGenerate.setIcon(ImgMenuXSDGenerateroll);
}                                               

private void MenuSchemaGenerateMouseExited(java.awt.event.MouseEvent evt) {                                               
    if (MenuSchemaGenerate.isEnabled())
        MenuSchemaGenerate.setIcon(ImgMenuXSDGeneratenorm);
}                                              

private void MenuVisualizerVisualizeMouseEntered(java.awt.event.MouseEvent evt) {                                                     
    if (MenuVisualizerVisualize.isEnabled())
        MenuVisualizerVisualize.setIcon(ImgMenuVisualizerVisualizeroll);
}                                                    

private void MenuVisualizerVisualizeMouseExited(java.awt.event.MouseEvent evt) {                                                    
    if (MenuVisualizerVisualize.isEnabled())
        MenuVisualizerVisualize.setIcon(ImgMenuVisualizerVisualizenorm);
}                                                   

private void MenuVisualizerEndVisualizationMouseEntered(java.awt.event.MouseEvent evt) {                                                            
    if (MenuVisualizerEndVisualization.isEnabled())
        MenuVisualizerEndVisualization.setIcon(ImgMenuVisualizerEndVisualizeroll);
}                                                           

private void MenuVisualizerEndVisualizationMouseExited(java.awt.event.MouseEvent evt) {                                                           
    if (MenuVisualizerEndVisualization.isEnabled())
        MenuVisualizerEndVisualization.setIcon(ImgMenuVisualizerEndVisualizenorm);
}                                                          

private void MenuVisualizerExportSQLMouseEntered(java.awt.event.MouseEvent evt) {                                                     
    if (MenuVisualizerExportSQL.isEnabled())
        MenuVisualizerExportSQL.setIcon(ImgMenuVisualizerExportSQLroll);
}                                                    

private void MenuVisualizerExportSQLMouseExited(java.awt.event.MouseEvent evt) {                                                    
    if (MenuVisualizerExportSQL.isEnabled())
        MenuVisualizerExportSQL.setIcon(ImgMenuVisualizerExportSQLnorm);
}                                                   

private void MenuFilePropertiesMouseEntered(java.awt.event.MouseEvent evt) {                                                
    if (MenuFileProperties.isEnabled())
        MenuFileProperties.setIcon(ImgMenuFilePropertiesroll);
}                                               

private void MenuFilePropertiesMouseExited(java.awt.event.MouseEvent evt) {                                               
    if (MenuFileProperties.isEnabled())
        MenuFileProperties.setIcon(ImgMenuFilePropertiesnorm);
}                                              

private void MenuFileExitMouseEntered(java.awt.event.MouseEvent evt) {                                          
    if (MenuFileExit.isEnabled())
        MenuFileExit.setIcon(ImgMenuFileExitroll);
}                                         

private void MenuFileExitMouseExited(java.awt.event.MouseEvent evt) {                                         
    if (MenuFileExit.isEnabled())
        MenuFileExit.setIcon(ImgMenuFileExitnorm);
}                                        

private void MenuHelpHelpMouseEntered(java.awt.event.MouseEvent evt) {                                          
    if (MenuHelpHelp.isEnabled())
        MenuHelpHelp.setIcon(ImgMenuHelpHelproll);
}                                         

private void MenuHelpHelpMouseExited(java.awt.event.MouseEvent evt) {                                         
    if (MenuHelpHelp.isEnabled())
        MenuHelpHelp.setIcon(ImgMenuHelpHelpnorm);
}                                        

private void MenuHelpDocumentationMouseEntered(java.awt.event.MouseEvent evt) {                                                   
    if (MenuHelpDocumentation.isEnabled())
        MenuHelpDocumentation.setIcon(ImgMenuHelpDocroll);
}                                                  

private void MenuHelpDocumentationMouseExited(java.awt.event.MouseEvent evt) {                                                  
    if (MenuHelpDocumentation.isEnabled())
        MenuHelpDocumentation.setIcon(ImgMenuHelpDocnorm);
}                                                 

private void MenuHelpAboutMouseEntered(java.awt.event.MouseEvent evt) {                                           
    if (MenuHelpAbout.isEnabled())
        MenuHelpAbout.setIcon(ImgMenuHelpAboutroll);
}                                          

private void MenuHelpAboutMouseExited(java.awt.event.MouseEvent evt) {                                          
    if (MenuHelpAbout.isEnabled())
        MenuHelpAbout.setIcon(ImgMenuHelpAboutnorm);
}                                         

/**
 * Metoda ktora otvara okno s Properties
 *
 * @param evt
 */
private void MenuFilePropertiesActionPerformed(java.awt.event.ActionEvent evt) {                                                   
    DisableMainWindow();
    if (MainWindow.XMLdocOpened || MainWindow.XSDdocOpened || MainWindow.XSDdocGenerated) {
        PropertiesFrame.ToggleDisplayModeChange(false);
    } else {
        PropertiesFrame.ToggleDisplayModeChange(true);
    }
    PropertiesFrame.SetProperties(XMLColor, XSDColor, SchemaOutputFormat, DisplayMode);
    PropertiesFrame.setLocationRelativeTo(this);
    PropertiesFrame.setVisible(true);
}                                                  

    /**
     * Metoda ktora sa vola kliknutim na Menu->Help->Documentation - zobrazi programovu dokumentaciu
     * 
     */
private void MenuHelpDocumentationActionPerformed(java.awt.event.ActionEvent evt) {                                                      
    helpContents = new HelpContents(DocPath);
    helpContents.Open();
}                                                     

// =====   END: blok mouseover grafickych zmien
    /**
     * Updatuje status bar
     * @param text text ktory sa zobrazi
     */
    public static void UpdateStatus(String text) {
        StatusText.setText(text);
    }

    /**
     * Metoda ktora ukonci aplikaciu
     * 
     */
    public static void QuitApplication() {
        System.exit(-1);
    }

    /**
     * Metoda ktora zobrazi vystraznu hlasku alebo error
     * 
     * @param header - String s nazovom chyby - Error/Warning
     * @param text - String s popisom chyby - napr nepodarilo sa otvorit subor.
     */
    public static void ShowMessage(String header, String text) {
        ApplicationMessageFrame.SetMessage(header, text);
        ApplicationMessageFrame.setLocationRelativeTo(MainWindow);
        ApplicationMessageFrame.setVisible(true);
    }

    /**
     * Metoda ktora nastavi farbu pisma
     * 
     */
    public static void ApplyConfigChanges() {
        TabsPaneXMLText.setForeground(XMLColor);
        TabsPaneXSDText.setForeground(XSDColor);
        try {
            XMLHandler.createConfig();
        } catch (IOException ex) {
            ShowMessage("ERROR!", "Could not save config file!");
        }
    }
    
    /**
     * Metoda ktora nastavi aky je vystup XML schemy
     * 
     * @param datatype cislo typu schemy
     */
    public static void XSDFileChooserSetExtension(int datatype) {
        switch (datatype) {
            case 1:
                TabsPane.setTitleAt(1, "RNC Schema");
                XSDFileChooser.setFileFilter(filterrnc);
                break;
            case 2:
                TabsPane.setTitleAt(1, "XML Schema");
                XSDFileChooser.setFileFilter(filterxsd);
                break;
            case 3:
                TabsPane.setTitleAt(1, "DTD");
                XSDFileChooser.setFileFilter(filterdtd);
                break;
            default:
                TabsPane.setTitleAt(1, "RNG Schema");
                XSDFileChooser.setFileFilter(filterrng);
                break;
        }
    }
    
    /**
     * Metoda ktora nastavi funkcionalitu tlacitok
     * 
     */
     public static void SetDisplayMode() {
        if (DisplayMode == 1) { // nemozno zobrazovat XML
            XMLdocOpened = false;
            XSDdocOpened = false;
            XSDdocGenerated = false;
            TabsPaneXMLText.setEditable(false);
            TabsPaneXMLText.setVisible(false);
            TabsPaneXSDText.setEditable(false);
            TabsPaneXSDText.setVisible(false);
            TabsPane.setEnabledAt(0, false);
            TabsPane.setEnabledAt(1, false);
            TabsPane.setEnabledAt(2, false);
            ToolbarOpenFile.setEnabled(false);
            ToolbarSaveFile.setEnabled(false);
            ToolbarCloseFile.setEnabled(false);
            ToolbarOpenSchema.setEnabled(false);
            ToolbarSaveSchema.setEnabled(false);
            ToolbarCloseSchema.setEnabled(false);
            ToolbarGenerateSchema.setEnabled(true);
            MenuXMLOpen.setEnabled(false);
            MenuXMLSave.setEnabled(false);
            MenuXMLClose.setEnabled(false);
            MenuSchemaOpen.setEnabled(false);
            MenuSchemaSave.setEnabled(false);
            MenuSchemaClose.setEnabled(false);
            MenuSchemaGenerate.setEnabled(true);
            ToolbarVisualize.setEnabled(false);
            MenuVisualizerVisualize.setEnabled(false);
            TabsPane.setSelectedIndex(1);
        } else if (DisplayMode == 2) { // nezobrazuje sa ani schema
            XMLdocOpened = false;
            XSDdocOpened = false;
            XSDdocGenerated = false;
            TabsPaneXMLText.setEditable(false);
            TabsPaneXMLText.setVisible(false);
            TabsPaneXSDText.setEditable(false);
            TabsPaneXSDText.setVisible(false);
            TabsPane.setEnabledAt(0, false);
            TabsPane.setEnabledAt(1, false);
            TabsPane.setEnabledAt(2, false);
            ToolbarOpenFile.setEnabled(false);
            ToolbarSaveFile.setEnabled(false);
            ToolbarCloseFile.setEnabled(false);
            ToolbarOpenSchema.setEnabled(false);
            ToolbarSaveSchema.setEnabled(false);
            ToolbarCloseSchema.setEnabled(false);
            ToolbarGenerateSchema.setEnabled(false);
            MenuXMLOpen.setEnabled(false);
            MenuXMLSave.setEnabled(false);
            MenuXMLClose.setEnabled(false);
            MenuSchemaOpen.setEnabled(false);
            MenuSchemaSave.setEnabled(false);
            MenuSchemaClose.setEnabled(false);
            MenuSchemaGenerate.setEnabled(false);
            ToolbarVisualize.setEnabled(true);
            MenuVisualizerVisualize.setEnabled(true);
            TabsPane.setSelectedIndex(2);
        } else { // default - vsetko vidno
            XMLdocOpened = false;
            XSDdocOpened = false;
            XSDdocGenerated = false;
            TabsPaneXMLText.setEditable(false);
            TabsPaneXMLText.setVisible(false);
            TabsPaneXSDText.setEditable(false);
            TabsPaneXSDText.setVisible(false);
            TabsPane.setEnabledAt(0, false);
            TabsPane.setEnabledAt(1, false);
            TabsPane.setEnabledAt(2, false);
            ToolbarOpenFile.setEnabled(true);
            ToolbarSaveFile.setEnabled(false);
            ToolbarCloseFile.setEnabled(false);
            ToolbarOpenSchema.setEnabled(true);
            ToolbarSaveSchema.setEnabled(false);
            ToolbarCloseSchema.setEnabled(false);
            ToolbarGenerateSchema.setEnabled(false);
            MenuXMLOpen.setEnabled(true);
            MenuXMLSave.setEnabled(false);
            MenuXMLClose.setEnabled(false);
            MenuSchemaOpen.setEnabled(true);
            MenuSchemaSave.setEnabled(false);
            MenuSchemaClose.setEnabled(false);
            MenuSchemaGenerate.setEnabled(false);
            ToolbarVisualize.setEnabled(false);
            MenuVisualizerVisualize.setEnabled(false);
            TabsPane.setSelectedIndex(0);
        }
        ToolbarEndVisualization.setEnabled(false);
        MenuVisualizerEndVisualization.setEnabled(false);
        ToolbarExportSQL.setEnabled(false);
        MenuVisualizerExportSQL.setEnabled(false);
     }
    
    /**
     * Metoda ktora nacita XML subor
     * Vypise ho do prislusneho tabu a nastavi flagy
     * 
     */
    public void XMLOpen() {
        UpdateStatus("Loading XML document...");
        if (XMLdocOpened) {
            /*final JOptionPane ChooseFrame1 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
            int n1 = ChooseFrame1.showConfirmDialog(MainWindow, "File already loaded!\n Save old file?", "Save?", ChooseFrame1.YES_NO_OPTION, ChooseFrame1.QUESTION_MESSAGE);
            if (n1 == 0) {
                XMLSave();
             }*/
            XMLClose();
        }
        //XMLClosed();
        if (!XMLdocOpened) {
            int returnVal = XMLFileChooser.showOpenDialog(MainWindow);
            switch (returnVal) {
                case JFileChooser.APPROVE_OPTION:
                    try {
                        XMLname = XMLFileChooser.getSelectedFile().getName();
                        XMLpath = XMLFileChooser.getSelectedFile().getPath();
                        XMLurl = XMLFileChooser.getSelectedFile().toURL();
                        //XMLdoc = XMLHandler.readDocument(XMLurl);
                        //XMLstring = XMLHandler.docToString(XMLdoc);
                        TabsPaneXMLText.setText(XMLHandler.docToString(XMLpath));
                        XMLOpened();
    /*                } catch (DocumentException ex) {
                        ShowMessage("ERROR!", "An error has occured while opening XML document.");
                        if (!XMLdocOpened) {
                            XMLstring = "";
                            TabsPaneXMLText.setText(XMLstring);
                        }
                        UpdateStatus("Ready."); */
                    } catch (MalformedURLException ex) {
                        ShowMessage("ERROR!", "Selected XML document doesn't exist.");
                        if (!XMLdocOpened) {
                            XMLstring = "";
                            TabsPaneXMLText.setText(XMLstring);
                        }
                        UpdateStatus("Ready.");
                    }
                    break;
                case JFileChooser.CANCEL_OPTION:
                    XMLFileChooser.cancelSelection();
                    break;
                case JFileChooser.ERROR_OPTION:
                    XMLFileChooser.cancelSelection();
                    ShowMessage("ERROR!", "JFileChooser error.");
                    break;
            }
        }
        UpdateStatus("Ready.");
    }

    /**
     * Metoda ktora povoli jendotlive tlacitka ked je XML subor otvoreny
     * 
     */
    public static void XMLOpened() {
        XMLdocOpened = true;
        TabsPaneXMLText.setEditable(true);
        TabsPaneXMLText.setVisible(true);
        TabsPaneXMLText.setCaretPosition(0);
        ToolbarOpenFile.setEnabled(true);
        ToolbarSaveFile.setEnabled(true);
        ToolbarCloseFile.setEnabled(true);
        ToolbarGenerateSchema.setEnabled(true);
        MenuXMLOpen.setEnabled(true);
        MenuXMLSave.setEnabled(true);
        MenuXMLClose.setEnabled(true);
        MenuSchemaGenerate.setEnabled(true);
        TabsPane.setEnabledAt(0, true);
        if (XMLdocOpened && XSDdocOpened) {
            ToolbarVisualize.setEnabled(true);
            MenuVisualizerVisualize.setEnabled(true);
            //TabsPane.setEnabledAt(2, true);
        }
        TabsPane.setSelectedIndex(0);
    }

    /**
     * Metoda ktora nacita XML subor na generovanie XML schemy.
     * Pouziva sa ked je iny mod zobrazovania ako klasicky
     *
     */
    public static void XMLOpenForGenerate() {
        UpdateStatus("Opening XML document...");
        int returnVal = XMLFileChooser.showOpenDialog(MainWindow);
        switch (returnVal) {
            case JFileChooser.APPROVE_OPTION:
                try {
                    XMLname = XMLFileChooser.getSelectedFile().getName();
                    XMLpath = XMLFileChooser.getSelectedFile().getPath();
                    XMLurl = XMLFileChooser.getSelectedFile().toURL();
                    XMLdocOpened = true;
                    XMLdoc = XMLHandler.readDocument(XMLpath);
                } catch (Exception ex) {
                    ShowMessage("ERROR!", "An error has occured while loading XML document!");
                    UpdateStatus("Ready.");
                } /*catch (MalformedURLException ex) {
                    ShowMessage("ERROR!", "Selected XML document doesn't exist!");
                    UpdateStatus("Ready.");
                }*/
                break;
            case JFileChooser.CANCEL_OPTION:
                XMLdocOpened = false;
                XMLFileChooser.cancelSelection();
                break;
            case JFileChooser.ERROR_OPTION:
                XMLdocOpened = false;
                XMLFileChooser.cancelSelection();
                ShowMessage("ERROR!", "JFileChooser error.");
                break;
        }
        UpdateStatus("Ready.");
    }
    /**
     * Metoda ktora ulozi otvorene xml 
     * 
     */
    public static void XMLSave() {
        UpdateStatus("Saving XML document...");
        int returnVal = XMLFileChooser.showSaveDialog(MainWindow);
        switch (returnVal) {
            case JFileChooser.APPROVE_OPTION:
                try {
                    String path = XMLFileChooser.getSelectedFile().getPath();
                    String t = ".xml";
                    if (path.substring(path.length() - 4).compareTo(t) != 0) {
                        path += t;
                    }
                    final File file = new File(path);
                    
                    if (file.exists()) {
                        final JOptionPane ChooseFrame = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
                        int n = ChooseFrame.showConfirmDialog(MainWindow, "File already exists!\n Overwrite?", "Owerwrite?", ChooseFrame.YES_NO_OPTION, ChooseFrame.QUESTION_MESSAGE);
                        if (n == 0) {
                            UpdateStatus("Saving XML document...");
                            XMLpath = path;
                            XMLHandler.writeFromString(TabsPaneXMLText.getText());
                            UpdateStatus("Ready.");
                        } else {
                            ShowMessage("WARNING!","XML document not saved!");
                        }
                        
                    } else {
                        UpdateStatus("Saving XML document...");
                        XMLpath = path;
                        XMLHandler.writeFromString(TabsPaneXMLText.getText());
                        UpdateStatus("Ready.");
                    }
                    

                } catch (IOException ex) {
                    ShowMessage("ERROR!", "An error has occured while saving XML document.");
                }
                break;
            case JFileChooser.CANCEL_OPTION:
                XMLFileChooser.cancelSelection();
                break;
            case JFileChooser.ERROR_OPTION:
                XMLFileChooser.cancelSelection();
                ShowMessage("ERROR!", "JFileChooser error.");
                break;
        }
        UpdateStatus("Ready.");
    }

    /**
     * Metoda ktora zavre XML subor, ponuke save dokumentu
     * 
     */
    public void XMLClose() {
        UpdateStatus("Closing document...");
        final JOptionPane ChooseFrame1 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
        int n1 = ChooseFrame1.showConfirmDialog(MainWindow, "Close current XML document?", "Close?", ChooseFrame1.YES_NO_OPTION, ChooseFrame1.QUESTION_MESSAGE);
        if (n1 == 0) {
            final JOptionPane ChooseFrame2 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
            int n2 = ChooseFrame2.showConfirmDialog(MainWindow, "Save current XML document?", "Save?", ChooseFrame2.YES_NO_OPTION, ChooseFrame2.QUESTION_MESSAGE);
                if (n2 == 0) {
                    XMLSave();
                }
            XMLClosed();
        }
        UpdateStatus("Ready.");
    }
    
    /**
     * Metoda ktora zakaze jendotlive tlacitka ked sa XML subor zavrie
     * 
     */
    public void XMLClosed() {
        XMLname = "";
        XMLpath = "";
        XMLurl = null;
        XMLdoc = null;
        XMLstring = "";
        XMLdocOpened = false;
        TabsPaneXMLText.setEditable(false);
        TabsPaneXMLText.setVisible(false);
        ToolbarOpenFile.setEnabled(true);
        ToolbarSaveFile.setEnabled(false);
        ToolbarCloseFile.setEnabled(false);
        ToolbarGenerateSchema.setEnabled(false);
        MenuXMLOpen.setEnabled(true);
        MenuXMLSave.setEnabled(false);
        MenuXMLClose.setEnabled(false);
        MenuSchemaGenerate.setEnabled(false);
        TabsPane.setEnabledAt(0, false);
        ToolbarVisualize.setEnabled(false);
        MenuVisualizerVisualize.setEnabled(false);
        if (XSDdocOpened) {
            TabsPane.setSelectedIndex(1);
        } else {
            TabsPane.setSelectedIndex(0);
        }
        XSDClosed();
    }
                            
    /**
     * Metoda ktora nacita XSD subor
     * Vypise ho do prislusneho tabu a nastavi flagy
     * 
     */
    public static void XSDOpen() {
        UpdateStatus("Loading XML schema file...");
        if (XSDdocOpened) {
            final JOptionPane ChooseFrame1 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
            int n1 = ChooseFrame1.showConfirmDialog(MainWindow, "File already loaded!\n Save old file?", "Save?", ChooseFrame1.YES_NO_OPTION, ChooseFrame1.QUESTION_MESSAGE);
            if (n1 == 0) {
                XSDSave();
             }
        }
        XSDFileChooserSetExtension(SchemaOutputFormat);
        int returnVal = XSDFileChooser.showOpenDialog(MainWindow);
        switch (returnVal) {
            case JFileChooser.APPROVE_OPTION:
                try {
                    XSDname = XSDFileChooser.getSelectedFile().getName();
                    XSDpath = XSDFileChooser.getSelectedFile().getPath();
                    UpdateStatus("Loading XML schema file...");
                    XSDurl = XSDFileChooser.getSelectedFile().toURL();
                    //XSDdoc = XSDHandler.readDocument(XSDpath);
                    XSDstring = XSDHandler.docToString(XSDpath);
                    TabsPaneXSDText.setText(XSDstring);
                    UpdateStatus("Ready.");
                    XSDOpened();
                } catch (Exception ex) {
                    ShowMessage("ERROR!", "An error has occured while opening XML schema file.");
                    if (!XSDdocOpened) {
                        XSDstring = "";
                        TabsPaneXSDText.setText(XSDstring);
                    }
                    UpdateStatus("Ready.");
                } /*catch (MalformedURLException ex) {
                    ShowMessage("ERROR!", "Selected XML schema file doesn't exist.");
                    if (!XSDdocOpened) {
                        XSDstring = "";
                        TabsPaneXSDText.setText(XSDstring);
                    }
                    UpdateStatus("Ready.");
                }*/
                break;
            case JFileChooser.CANCEL_OPTION:
                XMLFileChooser.cancelSelection();
                break;
            case JFileChooser.ERROR_OPTION:
                XMLFileChooser.cancelSelection();
                break;
        }
        UpdateStatus("Ready.");
    }

    /**
     * Metoda ktora povoli jendotlive tlacitka ked je XML subor otvoreny
     * 
     */
    public static void XSDOpened() {
        XSDdocOpened = true;
        TabsPaneXSDText.setEditable(true);
        TabsPaneXSDText.setVisible(true);
        TabsPaneXSDText.setCaretPosition(0);
        if (DisplayMode == 1) {
            ToolbarOpenSchema.setEnabled(false);
            MenuSchemaOpen.setEnabled(false);
            ToolbarVisualize.setEnabled(true);
            MenuVisualizerVisualize.setEnabled(true);
        } else {
            ToolbarOpenSchema.setEnabled(true);
            MenuSchemaOpen.setEnabled(true);
        }
        ToolbarSaveSchema.setEnabled(true);
        ToolbarCloseSchema.setEnabled(true);
        MenuSchemaSave.setEnabled(true);
        MenuSchemaClose.setEnabled(true);
        TabsPane.setEnabledAt(1, true);

        if (XMLdocOpened) {
            ToolbarGenerateSchema.setEnabled(true);
            MenuSchemaGenerate.setEnabled(true);
        }

        if (XMLdocOpened && XSDdocOpened) {
            ToolbarVisualize.setEnabled(true);
            MenuVisualizerVisualize.setEnabled(true);
            //TabsPane.setEnabledAt(2, true);
        }

        TabsPane.setSelectedIndex(1);
    }
    
    /**
     * Metoda ktora ulozi otvorenu schemu 
     * 
     */
    public static void XSDSave() {
        UpdateStatus("Saving XML schema...");
        XSDFileChooserSetExtension(SchemaOutputFormat);
        int returnVal = XSDFileChooser.showSaveDialog(MainWindow);
        switch (returnVal) {
            case JFileChooser.APPROVE_OPTION:
                try {
                    String path = XSDFileChooser.getSelectedFile().getPath();
                    String t = "";
                    switch (SchemaOutputFormat) {
                        case 1:
                            t = ".rnc";
                            break;
                        case 2:
                            t = ".xsd";
                            break;
                        case 3:
                            t = ".dtd";
                            break;
                        default:
                            t = ".rng";
                            break;
                    }
                    
                    if (path.substring(path.length() - 4).compareTo(t) != 0) {
                        path += t;
                    }
                    final File file = new File(path);
                    
                    if (file.exists()) {
                        final JOptionPane ChooseFrame = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
                        int n = ChooseFrame.showConfirmDialog(MainWindow, "File already exists!\n Overwrite?", "Owerwrite?", ChooseFrame.YES_NO_OPTION, ChooseFrame.QUESTION_MESSAGE);
                        if (n == 0) {
                            UpdateStatus("Saving XML schema...");
                            XSDpath = path;
                            XSDHandler.writeFromString(TabsPaneXSDText.getText());
                            UpdateStatus("Ready.");
                        } else {
                            ShowMessage("WARNING!","XML schema not saved!");
                        }

                    } else {
                        UpdateStatus("Saving XML schema...");
                        XSDpath = path;
                        XSDHandler.writeFromString(TabsPaneXSDText.getText());
                        UpdateStatus("Ready.");
                    }
                    

                } catch (IOException ex) {
                    ShowMessage("ERROR!", "An error has occured while saving XML schema file.");
                }
                break;
            case JFileChooser.CANCEL_OPTION:
                XSDFileChooser.cancelSelection();
                break;
            case JFileChooser.ERROR_OPTION:
                XSDFileChooser.cancelSelection();
                ShowMessage("ERROR!", "JFileChooser error.");
                break;
        }
        UpdateStatus("Ready.");
    }
    
    /**
     * Metoda ktora zavre schemu, ponukne save suboru
     * 
     */
    public void XSDClose() {
        UpdateStatus("Closing document...");
        final JOptionPane ChooseFrame1 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
        int n1 = ChooseFrame1.showConfirmDialog(MainWindow, "Close current XML schema file?", "Close?", ChooseFrame1.YES_NO_OPTION, ChooseFrame1.QUESTION_MESSAGE);
        if (n1 == 0) {
            final JOptionPane ChooseFrame2 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
            int n2 = ChooseFrame2.showConfirmDialog(MainWindow, "Save current XML schema file?", "Save?", ChooseFrame2.YES_NO_OPTION, ChooseFrame2.QUESTION_MESSAGE);
                if (n2 == 0) {
                    XSDSave();
                }
            XSDClosed();
        }
        UpdateStatus("Ready.");
    }
    
    /**
     * Metoda ktora zakaze jendotlive tlacitka ked sa schema zavrie
     * 
     */
    public void XSDClosed() {
        XSDname = "";
        XSDpath = "";
        XSDurl = null;
        XSDdoc = null;
        XSDstring = "";
        XSDdocOpened = false;
        XSDdocGenerated = false;
        TabsPaneXSDText.setEditable(false);
        TabsPaneXSDText.setVisible(false);
        if (DisplayMode == 1) {
            ToolbarOpenSchema.setEnabled(false);
            MenuSchemaOpen.setEnabled(false);
        } else {
            ToolbarOpenSchema.setEnabled(true);
            MenuSchemaOpen.setEnabled(true);
        }
        ToolbarSaveSchema.setEnabled(false);
        ToolbarCloseSchema.setEnabled(false);
        MenuSchemaSave.setEnabled(false);
        MenuSchemaClose.setEnabled(false);
        ToolbarVisualize.setEnabled(false);
        MenuVisualizerVisualize.setEnabled(false);
        TabsPane.setEnabledAt(1, false);
        TabsPane.setEnabledAt(2, false);
        ToolbarExportSQL.setEnabled(false);
        ToolbarEndVisualization.setEnabled(false);
        MenuVisualizerExportSQL.setEnabled(false);
        MenuVisualizerEndVisualization.setEnabled(false);
        if (XMLdocOpened) {
            ToolbarGenerateSchema.setEnabled(true);
            MenuSchemaGenerate.setEnabled(true);
        }
        TabsPane.setSelectedIndex(0);
        MainViewSplitPane.setDividerLocation(0);
        MainViewSplitPane.setEnabled(false);
        
        MainWindow.VisualizeTabsPane.removeAll();
        XMLTable = new JTable[XMLTableMaxCount];
        XMLTableScroller = new JScrollPane[XMLTableMaxCount];
        XMLTableName = new String[XMLTableMaxCount];
        XMLTableModel = new DefaultTableModel[XMLTableMaxCount];
        XMLTableActiveRowIndex = new int[XMLTableMaxCount];
        XMLTableCount = 0;
        XMLTableIndex = -1;
        ClearTree();

    }
    
    /**
     * Metoda ktora generuje schemu z XML dokumentu
     *
     */
    public void Generate() {
        UpdateStatus("Generating XML schema file...");
        if (XSDdocOpened) {
            final JOptionPane ChooseFrame1 = new JOptionPane (JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION);
            int n1 = ChooseFrame1.showConfirmDialog(MainWindow, "File already loaded!\n Save old file?", "Save?", ChooseFrame1.YES_NO_OPTION, ChooseFrame1.QUESTION_MESSAGE);
            if (n1 == 0) {
                XSDSave();
             }
            XSDdocOpened = false;
            XSDClosed();
        }
        UpdateStatus("Generating XML schema file...");
        try {
            XSDvirtualfilerng = new File(XSDvirtualfilerngpath);
            XSDvirtualfilerng.delete();
            XSDvirtualfilerng.createNewFile();
            if (DisplayMode == 1) {
                XMLOpenForGenerate();
            }
            if (XMLdocOpened) {
                XSDstring = "";
                try {
                    Generator.GenerateXMLtoRNG(XMLpath);
                } catch (Exception ex) {
                    ShowMessage("ERROR!","An error has occured while generating XML schema!\nXML document might not be valid!");
                }
                switch (SchemaOutputFormat) {
                    case 0:  // rng
                        XSDurl = XSDvirtualfilerng.toURL();
                        XSDpath = XSDvirtualfilerngpath;
                        XSDdoc = XSDHandler.readDocument(XSDpath);
                        XSDstring = XSDHandler.docToString(XSDpath);
                        TabsPaneXSDText.setText(XSDstring);
                        break;
                    case 1:  // rnc
                        XSDvirtualfilernc = new File(XSDvirtualfilerncpath);
                        XSDvirtualfilernc.delete();
                        Convertor.SchematoSchema(XSDvirtualfilerngpath, XSDvirtualfilerncpath, XSDvirtualfilernc);
                        XSDurl = XSDvirtualfilernc.toURL();
                        XSDpath = XSDvirtualfilerngpath;
                        //XSDdoc = XSDHandler.readDocument(XSDurl);
                        XSDstring = XSDHandler.readFile(XSDvirtualfilernc);
                        TabsPaneXSDText.setText(XSDstring);
                        break;
                    case 2:  // xsd
                        XSDvirtualfilexsd = new File(XSDvirtualfilexsdpath);
                        XSDvirtualfilexsd.delete();
                        Convertor.SchematoSchema(XSDvirtualfilerngpath, XSDvirtualfilexsdpath, XSDvirtualfilexsd);
                        XSDurl = XSDvirtualfilexsd.toURL();
                        XSDpath = XSDvirtualfilerngpath;
                        //XSDdoc = XSDHandler.readDocument(XSDurl);
                        XSDstring = XSDHandler.readFile(XSDvirtualfilexsd);
                        TabsPaneXSDText.setText(XSDstring);
                        break;
                    case 3:  // dtd
                        XSDvirtualfiledtd = new File(XSDvirtualfiledtdpath);
                        XSDvirtualfiledtd.delete();
                        Convertor.SchematoSchema(XSDvirtualfilerngpath, XSDvirtualfiledtdpath, XSDvirtualfiledtd);
                        XSDurl = XSDvirtualfiledtd.toURL();
                        XSDpath = XSDvirtualfilerngpath;
                        //XSDdoc = XSDHandler.readDocument(XSDurl);
                        XSDstring = XSDHandler.readFile(XSDvirtualfiledtd);
                        TabsPaneXSDText.setText(XSDstring);
                        break;
                    default:  // rng ( nepotrebne )
                        XSDurl = XSDvirtualfilerng.toURL();
                        XSDpath = XSDvirtualfilerngpath;
                        XSDdoc = XSDHandler.readDocument(XSDpath);
                        XSDstring = XSDHandler.docToString(XSDpath);
                        TabsPaneXSDText.setText(XSDstring);
                        break;
                }
                XSDdocGenerated = true;
                XSDOpened();
            }
        } catch (Exception ex) {
            ShowMessage("ERROR!","An error has occured while generating XML schema!\nXML document might not be valid!");
        }
        UpdateStatus("Ready.");
    }


    /**
     * Metoda volana ked je zapnuty iny mod zobrazenia ako zakladny, generuje schemu z XML
     *
     */
    public void GenerateForVisualize () {
        UpdateStatus("Initializing data for visualization...");
        try {
            XSDvirtualfilerng = new File(XSDvirtualfilerngpath);
            XSDvirtualfilerng.delete();
            XSDvirtualfilerng.createNewFile();
            XMLOpenForGenerate();
            if (XMLdocOpened) {
                try {
                    Generator.GenerateXMLtoRNG(XMLpath);
                    XSDpath = XSDvirtualfilerngpath;
                    XSDdocOpened = true;
                    XSDdocGenerated = true;
                } catch (Exception ex) {
                    ShowMessage("ERROR!","An error has occured while generating XML schema!\nXML document might not be valid!");
                }
            }
        } catch (Exception ex) {
            ShowMessage("ERROR!","An error has occured while processing XML document!\nXML document might not be valid!");
        }
        UpdateStatus("Ready.");
    }

    /**
     * Metoda ktora generuje TreeView - strom
     *
     */
    public void GenerateDOMTree() {
        UpdateStatus("Generating Tree View...");
        try {
            generatedTree.parseFile(new File(XMLpath));
            TreeView = new JTree(generatedTree.getTree().getModel());
            TreeView = generatedTree.getTree();
            TreeView.setModel(generatedTree.getTree().getModel());
            //ScrollPaneTreeView = new JScrollPane(TreeView);
            ScrollPaneTreeView.add(TreeView);
            ScrollPaneTreeView.setViewportView(TreeView);
            ScrollPaneTreeView.updateUI();
            ScrollPaneTreeView.setEnabled(true);
            ScrollPaneTreeView.setVisible(true);
            MainViewSplitPane.setDividerLocation(200);
            MainViewSplitPane.setEnabled(true);
        } catch (Exception ex) {
            ShowMessage("ERROR!","Error has occured while generating tree from XML file!");
        }
        //TreeView.setModel(new JDOMToTreeModelAdapter());
        //TreeView = generatedTree.getTree();
        //DefaultMutableTreeNode root_node = new DefaultMutableTreeNode(generatedTree.getTree().getModel().getRoot());
        //DefaultTreeModel treeModel = new DefaultTreeModel(root_node);
        //TreeView.setModel(treeModel);
        
        UpdateStatus("Ready.");
    }

    /**
     * Metoda ktora vycisti TreeView - strom
     *
     */
    public void ClearTree() {
        UpdateStatus("Generating Tree View...");
        try {
            generatedTree.parseFile(new File(EmptydocPath));
            TreeView = new JTree(generatedTree.getTree().getModel());
            TreeView = generatedTree.getTree();
            TreeView.setModel(generatedTree.getTree().getModel());
            //ScrollPaneTreeView = new JScrollPane(TreeView);
            ScrollPaneTreeView.add(TreeView);
            ScrollPaneTreeView.setViewportView(TreeView);
            ScrollPaneTreeView.updateUI();
            ScrollPaneTreeView.setEnabled(false);
            ScrollPaneTreeView.setVisible(false);
            MainViewSplitPane.setDividerLocation(5);
            MainViewSplitPane.setEnabled(false);
        } catch (Exception ex) {
            ShowMessage("ERROR!","Error has occured while generating tree from XML file!");
        }
        //TreeView.setModel(new JDOMToTreeModelAdapter());
        //TreeView = generatedTree.getTree();
        //DefaultMutableTreeNode root_node = new DefaultMutableTreeNode(generatedTree.getTree().getModel().getRoot());
        //DefaultTreeModel treeModel = new DefaultTreeModel(root_node);
        //TreeView.setModel(treeModel);

        UpdateStatus("Ready.");
    }
    
    /**
     * Metoda volana pri stiknuti tlacitka vizualize
     *
     */
    public void Visualize() {
        UpdateStatus("Running Visualizing module...");
        if (DisplayMode == 2) {
            GenerateForVisualize();
        } 
        if (XMLdocOpened && (XSDdocOpened || XSDdocGenerated)) {
            GenerateDOMTree();
            GenerateTables();
            //FulfillTables();
            TabsPane.setEnabledAt(2, true);
            ToolbarEndVisualization.setEnabled(true);
            MenuVisualizerEndVisualization.setEnabled(true);
            ToolbarExportSQL.setEnabled(true);
            MenuVisualizerExportSQL.setEnabled(true);
            XMLVisualized = true;
            //MainViewSplitPane.setDividerLocation(200);
        }
        UpdateStatus("Ready.");
    }


    /**
     * Metoda ktora generuje tabulky - vizualizacia
     *
     */
    public void GenerateTables() {
        UpdateStatus("Generating Tables View...");
       // try {
            MainWindow.VisualizeTabsPane.removeAll();
            XMLTable = new JTable[XMLTableMaxCount];
            XMLTableScroller = new JScrollPane[XMLTableMaxCount];
            XMLTableName = new String[XMLTableMaxCount];
            XMLTableModel = new DefaultTableModel[XMLTableMaxCount];
            XMLTableActiveRowIndex = new int[XMLTableMaxCount];
            XMLTableCount = 0;
            XMLTableIndex = -1;

            /*XMLTableCount = 1;
            XMLTableIndex = 0;
            XMLTableName[XMLTableIndex] = "Table1";*/
            TableCreator.parse();
            //TableCreator.AddFormatViewTable(XMLTableIndex);
            if (VisualizeTabsPane.getComponentCount() != 0) {
                TabsPane.setSelectedIndex(2);
                VisualizeTabsPane.setSelectedIndex(0);
            }
        /*} catch (Exception ex) {
            ShowMessage("ERROR!", "Visualizer could not create tables!");
        }*/
        UpdateStatus("Ready.");
    }


    /* deprecated
    public void FulfillTables() {
        UpdateStatus("Filling Tables with data...");
        
        // ak je tam aspon 1 tabulka potom
        TabsPane.setSelectedIndex(2);
        VisualizeTabsPane.setSelectedIndex(0);
        UpdateStatus("Ready.");
    }*/
    
    /**
     * Metoda main
     * 
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                MainWindow = new MainWindow();
            }
        });
    }
    // Variables declaration - do not modify
    private static javax.swing.JSplitPane MainViewSplitPane;
    private static javax.swing.JMenuBar Menu;
    private static javax.swing.JMenu MenuFile;
    private static javax.swing.JMenuItem MenuFileExit;
    private static javax.swing.JMenuItem MenuFileProperties;
    private static javax.swing.JMenu MenuHelp;
    private static javax.swing.JMenuItem MenuHelpAbout;
    private static javax.swing.JMenuItem MenuHelpDocumentation;
    private static javax.swing.JMenuItem MenuHelpHelp;
    private static javax.swing.JMenu MenuSchema;
    private static javax.swing.JMenuItem MenuSchemaClose;
    private static javax.swing.JMenuItem MenuSchemaGenerate;
    private static javax.swing.JMenuItem MenuSchemaOpen;
    private static javax.swing.JMenuItem MenuSchemaSave;
    private static javax.swing.JMenu MenuVisualizer;
    private static javax.swing.JMenuItem MenuVisualizerEndVisualization;
    private static javax.swing.JMenuItem MenuVisualizerExportSQL;
    private static javax.swing.JMenuItem MenuVisualizerVisualize;
    private static javax.swing.JMenu MenuXML;
    private static javax.swing.JMenuItem MenuXMLClose;
    private static javax.swing.JMenuItem MenuXMLOpen;
    private static javax.swing.JMenuItem MenuXMLSave;
    private javax.swing.JScrollPane ScrollPaneTreeView;
    private static javax.swing.JPanel StatusPanel;
    private static javax.swing.JProgressBar StatusProgress;
    private static javax.swing.JLabel StatusText;
    private static javax.swing.JTabbedPane TabsPane;
    private javax.swing.JPanel TabsPaneTables;
    private javax.swing.JPanel TabsPaneXDS;
    private javax.swing.JPanel TabsPaneXML;
    private static javax.swing.JScrollPane TabsPaneXMLScrollPane;
    private static javax.swing.JTextArea TabsPaneXMLText;
    private javax.swing.JScrollPane TabsPaneXSDSrollPane;
    private static javax.swing.JTextArea TabsPaneXSDText;
    private static javax.swing.JToolBar Toolbar;
    private static javax.swing.JButton ToolbarCloseFile;
    private static javax.swing.JButton ToolbarCloseSchema;
    private static javax.swing.JButton ToolbarEndVisualization;
    private static javax.swing.JButton ToolbarExportSQL;
    private static javax.swing.JButton ToolbarGenerateSchema;
    private static javax.swing.JButton ToolbarOpenFile;
    private static javax.swing.JButton ToolbarOpenSchema;
    private static javax.swing.JButton ToolbarSaveFile;
    private static javax.swing.JButton ToolbarSaveSchema;
    private static javax.swing.JToolBar.Separator ToolbarSeparator1;
    private static javax.swing.JToolBar.Separator ToolbarSeparator2;
    private static javax.swing.JButton ToolbarVisualize;
    public static javax.swing.JTabbedPane VisualizeTabsPane;
    // End of variables declaration
    // Moje premenne
    /** Trieda ktora vykresluje hlavne okno z tadialto sa vola vacsina metod */
    public static MainWindow MainWindow = null;
    /** Trieda ktora vykresluje okno pri vypinani aplikacie */
    public static XQuitFrame QuitFrame = null;
    /** Trieda ktora vykresluje okno About */
    public static XAboutFrame AboutFrame = null;
    /** Trieda ktora vykresluje okno s errorovymi hlaskami */
    public static XApplicationMessageFrame ApplicationMessageFrame = null;
    /** Trieda ktora vykresluje okno s nastaveniami */
    public static XPropertiesFrame PropertiesFrame = null;
    
    /** Trieda volajúca okno s aboutom */
    protected static HelpContents helpContents;
    /** cesta k súboru s nápovedou */
    public static String HelpPath = "doc/help/helpcontents.html";
    /** cesta k súboru s dokumentaciou */
    public static String DocPath = "doc/javadoc/index.html";
    /** cesta k "prazdnemu" suboru */
    public static final String EmptydocPath = "other/empty.xml";
    
    /** Filter pre *.xml súbory */
    protected static ExampleFileFilter filterxml;
    /** Okno na ukladanie alebo load/save XML suborov */
    protected static JFileChooser XMLFileChooser;
    /** nazov suboru z/do sa dava XML */
    public static String XMLname = "";
    /** cesta ku XML suboru */
    public static String XMLpath = "";
    /** cesta k xml suboru */
    public static java.net.URL XMLurl = null;
    /** trieda typu document pre XML dokument */
    public static org.jdom.Document XMLdoc;
    /** string obsahujuci cely XML subor */
    public static String XMLstring;
    /** farba akou sa vypisuje XML dokument */
    public static Color XMLColor = new Color(0, 0, 0);
    /** premenna ktorej sa generuje strom z xml suboru */
    private static XMLTree generatedTree;
    /** premenna ktora sa vykresli do scroll pane */
    private JTree TreeView;
    
    /** Filter pre *.rng súbory */
    protected static ExampleFileFilter filterrng;
    /** Filter pre *.rnc súbory */
    protected static ExampleFileFilter filterrnc;
    /** Filter pre *.xsd súbory */
    protected static ExampleFileFilter filterxsd;
    /** Filter pre *.dtd súbory */
    protected static ExampleFileFilter filterdtd;
    /** Okno na ukladanie alebo load/save XML schem */
    protected static JFileChooser XSDFileChooser;
    /** nazov suboru z/do sa dava XML schema */
    public static String XSDname = "";
    /** cesta k suboru s XML schemou */
    public static String XSDpath = "";
    /** cesta k suboru s XML schemou */
    public static java.net.URL XSDurl = null;
    /** trieda typu document pre XML schemu */
    public static org.jdom.Document XSDdoc;
    /** string obsahujuci celu XML schemu */
    public static String XSDstring;
    /** farba akou sa vypisuje XML schema */
    public static Color XSDColor = new Color(0, 80, 0);
    /** trieda konvertoru - v baliku convert */
    public Driver Convertor;
    /** trieda generatoru - v baliku xmltorng */
    public SchemaGenerator Generator;
    
    
    
    protected static final int XMLTableMaxCount = 30;
    public static JTable[] XMLTable = new JTable[XMLTableMaxCount] ;
    public static JScrollPane[] XMLTableScroller = new JScrollPane[XMLTableMaxCount];;
    public static String[] XMLTableName = new String[XMLTableMaxCount];
    public static DefaultTableModel[] XMLTableModel = new DefaultTableModel[XMLTableMaxCount];
    public static int[] XMLTableActiveRowIndex = new int[XMLTableMaxCount];
    public static int XMLTableCount = 0;
    public static int XMLTableIndex = -1;
    
    public static File XSDvirtualfilerng = null;
    public static final String XSDvirtualfilerngpath = "other/virtualout.rng";
    public static final String XSDvirtualfilerngname = "virtualout.rng";
    public static File XSDvirtualfilernc = null;
    public static final String XSDvirtualfilerncpath = "other/virtualout.rnc";
    public static final String XSDvirtualfilerncname = "virtualout.rnc";
    public static File XSDvirtualfilexsd = null;
    public static final String XSDvirtualfilexsdpath = "other/virtualout.xsd";
    public static final String XSDvirtualfilexsdname = "virtualout.xsd";
    public static File XSDvirtualfiledtd = null;
    public static final String XSDvirtualfiledtdpath = "other/virtualout.dtd";
    public static final String XSDvirtualfiledtdname = "virtualout.dtd";
    
    // FLAGS
    /** premenna ktora urcuje ci uz je nejaky XML subor otvoreny */
    public static boolean XMLdocOpened = false;
    /** premenna ktora urcuje ci sa uz s nejakym .xsd suborom pracuje */
    public static boolean XSDdocOpened = false;
    /** premenna ktora urcuje ci bola dana schema vygenerovana */
    public static boolean XSDdocGenerated = false;
    /** premenna ktora urcuje ci prebehla visualizacia xml */
    public static boolean XMLVisualized = false;
    /** premenna ktora uchovava index naposledy selectnuteho tabu */
    private static int TabsPanelastSelectedIndex = -1;
    /** premenna ktora urcute typ vystupu xml schemy */
    // 0 = rng   1 = rnc   2 = xsd   3 = dtd
    public static int SchemaOutputFormat = 0;
    /** premenna ktora urcuje typy zobrazenia suborov */
    // 0 = normal   1 = nezobrazuje sa xml   2 = zobrazuju sa priamo az tabulky 
    public static int DisplayMode = 0;
    
    // konstanty
    protected static final Color TabsPaneSelectedForeground = new Color(128, 0, 0);
    protected static final Color TabsPaneNormalForeground = new Color(0, 0, 0);
    
    // obrazky toolbaru
    protected static final ImageIcon ImgToolbarXMLOpennorm = new javax.swing.ImageIcon("img/xmlopenn.gif");
    protected static final ImageIcon ImgToolbarXMLOpenroll = new javax.swing.ImageIcon("img/xmlopenr.gif");
    protected static final ImageIcon ImgToolbarXMLSavenorm = new javax.swing.ImageIcon("img/xmlsaven.gif");
    protected static final ImageIcon ImgToolbarXMLSaveroll = new javax.swing.ImageIcon("img/xmlsaver.gif");
    protected static final ImageIcon ImgToolbarXMLClosenorm = new javax.swing.ImageIcon("img/xmlclosen.gif");
    protected static final ImageIcon ImgToolbarXMLCloseroll = new javax.swing.ImageIcon("img/xmlcloser.gif");
    protected static final ImageIcon ImgToolbarXSDOpennorm = new javax.swing.ImageIcon("img/xsdopenn.gif");
    protected static final ImageIcon ImgToolbarXSDOpenroll = new javax.swing.ImageIcon("img/xsdopenr.gif");
    protected static final ImageIcon ImgToolbarXSDSavenorm = new javax.swing.ImageIcon("img/xsdsaven.gif");
    protected static final ImageIcon ImgToolbarXSDSaveroll = new javax.swing.ImageIcon("img/xsdsaver.gif");
    protected static final ImageIcon ImgToolbarXSDClosenorm = new javax.swing.ImageIcon("img/xsdclosen.gif");
    protected static final ImageIcon ImgToolbarXSDCloseroll = new javax.swing.ImageIcon("img/xsdcloser.gif");
    protected static final ImageIcon ImgToolbarXSDGeneratenorm = new javax.swing.ImageIcon("img/xsdgeneraten.gif");
    protected static final ImageIcon ImgToolbarXSDGenerateroll = new javax.swing.ImageIcon("img/xsdgenerater.gif");
    protected static final ImageIcon ImgToolbarVisualizenorm = new javax.swing.ImageIcon("img/visualizen.gif");
    protected static final ImageIcon ImgToolbarVisualizeroll = new javax.swing.ImageIcon("img/visualizer.gif");
    protected static final ImageIcon ImgToolbarEndVisualizenorm = new javax.swing.ImageIcon("img/endvisualizen.gif");
    protected static final ImageIcon ImgToolbarEndVisualizeroll = new javax.swing.ImageIcon("img/endvisualizer.gif");
    protected static final ImageIcon ImgToolbarExportSQLnorm = new javax.swing.ImageIcon("img/exportsqln.gif");
    protected static final ImageIcon ImgToolbarExportSQLroll = new javax.swing.ImageIcon("img/exportsqlr.gif");
    
    // obrazky menu
    protected static final ImageIcon ImgMenuXMLOpennorm = new javax.swing.ImageIcon("img/menuxmlopenn.gif");
    protected static final ImageIcon ImgMenuXMLOpenroll = new javax.swing.ImageIcon("img/menuxmlopenr.gif");
    protected static final ImageIcon ImgMenuXMLSavenorm = new javax.swing.ImageIcon("img/menuxmlsaven.gif");
    protected static final ImageIcon ImgMenuXMLSaveroll = new javax.swing.ImageIcon("img/menuxmlsaver.gif");
    protected static final ImageIcon ImgMenuXMLClosenorm = new javax.swing.ImageIcon("img/menuxmlclosen.gif");
    protected static final ImageIcon ImgMenuXMLCloseroll = new javax.swing.ImageIcon("img/menuxmlcloser.gif");
    protected static final ImageIcon ImgMenuXSDOpennorm = new javax.swing.ImageIcon("img/menuxsdopenn.gif");
    protected static final ImageIcon ImgMenuXSDOpenroll = new javax.swing.ImageIcon("img/menuxsdopenr.gif");
    protected static final ImageIcon ImgMenuXSDSavenorm = new javax.swing.ImageIcon("img/menuxsdsaven.gif");
    protected static final ImageIcon ImgMenuXSDSaveroll = new javax.swing.ImageIcon("img/menuxsdsaver.gif");
    protected static final ImageIcon ImgMenuXSDClosenorm = new javax.swing.ImageIcon("img/menuxsdclosen.gif");
    protected static final ImageIcon ImgMenuXSDCloseroll = new javax.swing.ImageIcon("img/menuxsdcloser.gif");
    protected static final ImageIcon ImgMenuXSDGeneratenorm = new javax.swing.ImageIcon("img/menuxsdgeneraten.gif");
    protected static final ImageIcon ImgMenuXSDGenerateroll = new javax.swing.ImageIcon("img/menuxsdgenerater.gif");
    protected static final ImageIcon ImgMenuVisualizerVisualizenorm = new javax.swing.ImageIcon("img/menuvisualizen.gif");
    protected static final ImageIcon ImgMenuVisualizerVisualizeroll = new javax.swing.ImageIcon("img/menuvisualizer.gif");
    protected static final ImageIcon ImgMenuVisualizerEndVisualizenorm = new javax.swing.ImageIcon("img/menuendvisualizen.gif");
    protected static final ImageIcon ImgMenuVisualizerEndVisualizeroll = new javax.swing.ImageIcon("img/menuendvisualizer.gif");
    protected static final ImageIcon ImgMenuVisualizerExportSQLnorm = new javax.swing.ImageIcon("img/menuexportsqln.gif");
    protected static final ImageIcon ImgMenuVisualizerExportSQLroll = new javax.swing.ImageIcon("img/menuexportsqlr.gif");
    protected static final ImageIcon ImgMenuFilePropertiesnorm = new javax.swing.ImageIcon("img/menufilepropertiesn.gif");
    protected static final ImageIcon ImgMenuFilePropertiesroll = new javax.swing.ImageIcon("img/menufilepropertiesr.gif");
    protected static final ImageIcon ImgMenuFileExitnorm = new javax.swing.ImageIcon("img/menufileexitn.gif");
    protected static final ImageIcon ImgMenuFileExitroll = new javax.swing.ImageIcon("img/menufileexitr.gif");
    protected static final ImageIcon ImgMenuHelpHelpnorm = new javax.swing.ImageIcon("img/menuhelpn.gif");
    protected static final ImageIcon ImgMenuHelpHelproll = new javax.swing.ImageIcon("img/menuhelpr.gif");
    protected static final ImageIcon ImgMenuHelpDocnorm = new javax.swing.ImageIcon("img/menudocn.gif");
    protected static final ImageIcon ImgMenuHelpDocroll = new javax.swing.ImageIcon("img/menudocr.gif");
    protected static final ImageIcon ImgMenuHelpAboutnorm = new javax.swing.ImageIcon("img/menuaboutn.gif");
    protected static final ImageIcon ImgMenuHelpAboutroll = new javax.swing.ImageIcon("img/menuaboutr.gif");
}
