package convert.relaxng.output.rnc;

import convert.relaxng.edit.SchemaCollection;
import convert.relaxng.edit.SchemaDocument;
import convert.relaxng.output.OutputDirectory;
import convert.relaxng.output.OutputDirectoryParamProcessor;
import convert.relaxng.output.OutputFailedException;
import convert.relaxng.output.OutputFormat;
import convert.relaxng.output.common.ErrorReporter;
import convert.relaxng.translate.util.InvalidParamsException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.util.Map;

public class RncOutputFormat implements OutputFormat {
  public void output(SchemaCollection sc, OutputDirectory od, String[] params, String inputFormat, ErrorHandler eh)
          throws SAXException, IOException, OutputFailedException, InvalidParamsException {
    new OutputDirectoryParamProcessor(od).process(params, eh);
    try {
      ErrorReporter er = new ErrorReporter(eh, RncOutputFormat.class);
      for (Map.Entry<String, SchemaDocument> entry : sc.getSchemaDocumentMap().entrySet()) {
        outputPattern(entry.getValue(), entry.getKey(), od, er);
      }
    }
    catch (ErrorReporter.WrappedSAXException e) {
      throw e.getException();
    }
  }

  private static void outputPattern(SchemaDocument sd, String sourceUri, OutputDirectory od, ErrorReporter er) throws IOException {
    Output.output(sd.getPattern(),
                  sd.getEncoding(),
                  sourceUri,
                  od,
                  er);
  }

}
