/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package base.tree;

import java.awt.Color;
import java.awt.Component;

import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.jdom.*;

/**
 *
 * @author illi
 */
public class XMLTreeCellRenderer extends DefaultTreeCellRenderer {
    
    //colors for tree items
    private final Color elementColor = new Color(0, 0, 128);
    private final Color textColor = new Color(0, 128, 0);
    
    // custom
    private String attribute_name;
    private String attribute_value;
    private Attribute atribut;
    private List<Attribute> att_list;
    //end custom
    
    //remove icons
    public XMLTreeCellRenderer() {
        setOpenIcon(new ImageIcon("open.gif"));
        setClosedIcon(new ImageIcon("closed.gif"));
        setLeafIcon(new ImageIcon("leaf.gif"));
    }
    
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JDOMAdapterNode adapterNode = (JDOMAdapterNode)value;
        if(adapterNode.node.isRootElement()) {
            value = adapterNode.node.getName();
        } else if(adapterNode.node.getChildren().size() > 0) {

            // custom
            value = adapterNode.node.getName();
            att_list = adapterNode.node.getAttributes();
            for (int i = 0; i < att_list.size(); i++) {
                atribut = att_list.get(i);
                attribute_name = atribut.getName();
                attribute_value = atribut.getValue();
                value = value.toString() +  " <" + adapterNode.node.getAttributeValue(attribute_name) + ">";
            }
            // end custom
            
        } else {
            value = adapterNode.node.getName() +" : "+adapterNode.node.getTextNormalize();
        }
        
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        
        if(!selected) {
            if(adapterNode.node.getTextNormalize().length() == 0) {
                setForeground(elementColor);
            } else {
                setForeground(textColor);
            }
        }
        
        return this;
        
    }
}
