package convert.relaxng.output.xsd.basic;

import convert.relaxng.edit.SourceLocation;

public class SimpleTypeRef extends SimpleType {
  private final String name;

  public SimpleTypeRef(SourceLocation location, Annotation annotation, String name) {
    super(location, annotation);
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public <T> T accept(SimpleTypeVisitor<T> visitor) {
    return visitor.visitRef(this);
  }

  public boolean equals(Object obj) {
    return super.equals(obj) && ((SimpleTypeRef)obj).name.equals(name);
  }

  public int hashCode() {
    return super.hashCode() ^ name.hashCode();
  }
}
