/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */


package base.table;

import base.*;


import java.awt.Color;
import java.awt.Font;
import java.lang.Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.*;
import java.io.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import org.jdom.*;
//import org.dom4j.DocumentException;
//import org.dom4j.Element;

/**
 *
 * @author illi
 */
public class TableCreator {
    //private static DefaultTableModel tmodel = new DefaultTableModel(10, 10);
    protected static final Font TableFont = new Font("Arial", Font.PLAIN, 11);
    //protected static final DefaultListSelectionModel SelModel = new DefaultListSelectionModel();
    protected static final Color GridColor = new Color(0, 0, 100);
    protected static final Color FgColor = new Color(0, 0, 0);
    protected static final Color BgColor = new Color(255, 255, 255);
    protected static final Color HeaderFgColor = new Color(0, 100, 0);
    protected static final Color HeaderBgColor = new Color(255, 100, 0);
    //protected static final Color SelectionFgColor = new Color(0, 100, 255);
    //protected static final Color SelectionBgColor = new Color(0, 255, 0);
    private static Element schemaroot;
    private static Element xmlroot;
    private static List<Element> childlist;// = new ArrayList<Element>();
    private static boolean onnextcreatetable = false;
    private static List<Element> referencelist;// = new ArrayList<Element>();
    private static List<Element> interreferencelist;// = new ArrayList<Element>();
    private static List<Element> referencenamelist;// = new ArrayList<Element>();
    private static Element refelement;
    private static List<Element> xmllist;
    //private static Element parentelement;
    private static Element currentelement;
    private static Element previouselement;
    private static Element nextelement;
    private static String currenttablename;
    private static int currenttableindex;

    /**
     * Metoda ktora vykona celu vizualizaciu tabulkami
     *
     */
    public static void parse() {
        try {
            MainWindow.XMLdoc = XMLHandler.readDocument(MainWindow.XMLpath);
            MainWindow.XSDdoc = XMLHandler.readDocument(MainWindow.XSDpath);
        } catch (Exception ex) {
            MainWindow.ShowMessage("ERROR!", "Could not read required files!\n Visualization cancelled.");
        }
        
        if ((MainWindow.XSDdoc != null) && (MainWindow.XMLdoc != null)) {

            try {
            xmlroot = MainWindow.XMLdoc.getRootElement();
            schemaroot = MainWindow.XSDdoc.getRootElement();
            childlist = schemaroot.getChildren(); //v liste je start + mozno referencie

// ===== start: nacitanie <define> elementov zo schemy
            if (childlist.size() > 1) {
                referencenamelist = new LinkedList(childlist);
                /*referencenamelist.clear();
                referencelist = new LinkedList(childlist); // = childlist.subList(1, childlist.size() - 1); // odstranit "start"
                for (int i = 0; i < referencelist.size(); i++) {
                    refelement = childlist.get(i);
                    interreferencelist = new LinkedList(refelement.getChildren());
                    refelement = interreferencelist.get(0);
                    referencenamelist.add(i, refelement);
                }*/

            } else {
                referencelist = null;
                referencenamelist = null;
            }
// ======= end: nacitanie <define> elementov zo schemy

            //GetReferencedElements(schemaroot);
            //refelement = childlist.get(0);
            //childlist.clear();//v liste je prvy element
            //childlist = refelement.getChildren();
            //childlist = new LinkedList();
            childlist = childlist.get(0).getChildren();
            if (childlist.get(0).getName().toLowerCase().compareTo("element") != 0) {
                MainWindow.ShowMessage("ERROR!", "Invalid schema file!\n Visualization cancelled.");
            } else {
                // vygeneruj stlpce
                CreateTable(childlist.get(0).getAttributeValue("name").toString());
                childlist = new LinkedList<Element>(childlist.get(0).getChildren()); // dalsie elementy
                MainWindow.XMLTableActiveRowIndex[0]++;
                ChildrenListHandle(childlist);

                // napln riadky
                currenttablename = xmlroot.getName();
                currenttableindex = 0;
                xmllist = xmlroot.getChildren();

                int indexer = 0;
                try {

                    for (indexer = 0; indexer < MainWindow.XMLTableCount; indexer++) {
                        AddFormatViewTable(indexer);
                        String[] emptyline = {""};
                        MainWindow.XMLTableModel[indexer].addRow(emptyline);
                    }
                    

                } catch (Exception ex) {
                    MainWindow.ShowMessage("ERROR!", "Input is either too big or an internal error occured!\n Visualization cancelled!");
                }

                // tuna sa budu tabulky plnit
                FillTables(xmllist, -1);
                RemoveEmptyRows();
                // prvy riadok zapis ako columny
                String columnname;
                for (indexer = 0; indexer < MainWindow.XMLTableCount; indexer++) {
                    for (int colindexer = 0; colindexer < MainWindow.XMLTableModel[indexer].getColumnCount(); colindexer++) {
                        columnname = MainWindow.XMLTableModel[indexer].getValueAt(0, colindexer).toString();
                        MainWindow.XMLTable[indexer].getColumnModel().getColumn(colindexer).setHeaderValue(columnname);
                    }
                    MainWindow.XMLTableModel[indexer].removeRow(0);
                }
                for (indexer = 0; indexer < MainWindow.XMLTableCount; indexer++) {
                    for (int rowindexer = 0; rowindexer < MainWindow.XMLTableModel[indexer].getRowCount(); rowindexer++) {
                        rowindexer++;
                        MainWindow.XMLTableModel[indexer].setValueAt(rowindexer, rowindexer-1, 0);
                        rowindexer--;
                    }
                }
                boolean nodata = true;
                for (indexer = 0; indexer < MainWindow.XMLTableCount; indexer++) {
                    if (MainWindow.XMLTableModel[indexer].getRowCount() > 0) {
                        nodata = false;
                    }
                }
                if (nodata) {
                    MainWindow.ShowMessage("ERROR!", "XML document and schema dont match!");
                }
            }
           } catch (Exception ex) {
                MainWindow.ShowMessage("ERROR!", "Generate or open a RNG schema file!\n Visualization cancelled.");
           }
        } else {
            MainWindow.ShowMessage("ERROR!", "An error has occured while loading input files!\n Visualization cancelled.");
        }
    }

    /**
     * Metoda na odstranenie prazdnych riadkov v tabulke
     *
     */
    public static void RemoveEmptyRows() {
        boolean rowdelete = true;
        for (int tableindex = 0; tableindex < MainWindow.XMLTableCount; tableindex++) {
            for (int tablerowindex = 0; tablerowindex < MainWindow.XMLTable[tableindex].getRowCount(); tablerowindex++) {
                rowdelete = true;
                for (int tablecolindex = 0; tablecolindex < MainWindow.XMLTable[tableindex].getColumnCount(); tablecolindex++) {
                    try {
                        if (MainWindow.XMLTable[tableindex].getValueAt(tablerowindex, tablecolindex).toString().length() > 0) {
                            rowdelete = false;
                        }
                    } catch (NullPointerException ex){
                        // zachyti null pointer
                    }
                }
                if (rowdelete) {
                    MainWindow.XMLTableModel[tableindex].removeRow(tablerowindex);
                }
                rowdelete = true;
            }
        }

    }



    /* obsolete
    public static void GetReferencedElements(Element xsdroot) {
        List<Element> rootchildrenlist = xsdroot.getChildren(); // start + define + define atd

        if (rootchildrenlist.size() > 1) {
            referencenamelist = rootchildrenlist;
            //referencenamelist.clear();
            referencelist = rootchildrenlist;// = childlist.subList(1, childlist.size() - 1); // odstranit "start"
            rootchildrenlist.iterator().next().getChildren();
            for (int i = 0; i < referencelist.size(); i++) {
                interreferencelist = rootchildrenlist.get(i).getChildren();
                refelement = interreferencelist.get(0);
                referencenamelist.add(i, refelement);
            }

        } else {
            referencelist = null;
            referencenamelist = null;
        }
    
    }*/







    /**
     * Metoda ktora plni riadky tabulky
     *
     * @param xlist zoznam elementov v xml subore
     * @param pti index predoslej tabulky
     */
    public static void FillTables(List<Element> xlist, int pti) {
        Element activee;
        int elementrowindex;
        int previoustableindex = pti;
        Element parentactivee;
        int pindex = 0; // index rodica
        List<Attribute> atributelist;
        int atributerowindex;

        for (int i = 0; i < xlist.size(); i++) {
            activee = xlist.get(i);
            parentactivee = activee.getParentElement();
            if (parentactivee != null) {
                pindex = ElementTableIndex(parentactivee.getName(), 0);
                if (pindex < 0) {
                    pindex = 0;
                }

            }

            elementrowindex = ElementTableIndex(activee.getName(), pindex);
            
            if (activee.getChildren().isEmpty()) { // ak nema deti,
                // ak element neni meno tabulky
                if (SearchTableName(activee.getName().toString()) == -1) {
                    // ak je v tabulke volne miesto
                    if (elementrowindex != -1) {
                        MainWindow.XMLTable[currenttableindex].setValueAt((activee.getTextNormalize()),
                                MainWindow.XMLTableActiveRowIndex[currenttableindex], elementrowindex);
                    } // ak nieje v tabulke volne miesto bude sa riesit ...
                    else {

                    }
                    // ak element ma deti a sam neni nazov tabulky, tak dalsie elementy budu sa brat odtial - zo zoznamu deti
                    if (activee.getChildren().isEmpty()) {
                        // do nothing
                    } else {
                        FillTables(activee.getChildren(), previoustableindex);
                    }

                } // ak je element meno tabulky
                else {
                        // nastavi sa index tabulky
                        previoustableindex = currenttableindex;
                        currenttableindex = SearchTableName(activee.getName().toString());// malo by to byt ++
                        //vlozi na zaciatok attributy, mozno aj do starej tabulky by mohol
                        atributelist = activee.getAttributes();
                        if (!atributelist.isEmpty()) {
                            for (int zzz = 0; zzz < atributelist.size(); zzz++) {
                                atributerowindex = ElementTableIndex(atributelist.get(zzz).getName(), 0);
                                if (atributerowindex != -1) {
                                    MainWindow.XMLTable[currenttableindex].setValueAt(atributelist.get(zzz).getValue(),
                                    MainWindow.XMLTableActiveRowIndex[currenttableindex], atributerowindex);
                                }
                            }
                        }

                    //SearchTableName(activee.getName().toString());
                }
                // ak element ma decka a sam neni nazov tabulky, tak dalsie elementy budu sa brat odtial - z deciek


                // ak je to posledny element v tabulke
                if (elementrowindex >= (MainWindow.XMLTable[currenttableindex].getColumnCount() - 1)) {
                    MainWindow.XMLTableActiveRowIndex[currenttableindex]++;
                    
                    String[] emptyline = {""};
                    MainWindow.XMLTableModel[currenttableindex].addRow(emptyline);
                    
                }
            } else { // ak ma deti
                if (SearchTableName(activee.getName().toString()) == -1) {
                    // ak je v tabulke volne miesto
                   /* if (elementrowindex != -1) {
                        MainWindow.XMLTable[currenttableindex].setValueAt(activee.getTextNormalize(),
                                MainWindow.XMLTableActiveRowIndex[currenttableindex], elementrowindex);
                    } // ak nieje v tabulke volne miesto bude sa riesit ...
                    else {

                    }*/
                    // ak element ma deti a sam neni nazov tabulky, tak dalsie elementy budu sa brat odtial - zo zoznamu deti
                    if (activee.getChildren().isEmpty()) {
                        // do nothing
                    } else {
                        FillTables(activee.getChildren(), previoustableindex);
                    }

                } // ak je element meno tabulky
                else {
                        // nastavi sa index tabulky
                        int bpti = previoustableindex;
                        previoustableindex = currenttableindex;
                        currenttableindex = SearchTableName(activee.getName().toString());// malo by to byt ++
                        //vlozi na zaciatok attributy, mozno aj do starej tabulky by mohol
                        //vlozi na zaciatok attributy, mozno aj do starej tabulky by mohol
                        atributelist = activee.getAttributes();
                        if (!atributelist.isEmpty()) {
                            for (int zzz = 0; zzz < atributelist.size(); zzz++) {
                                atributerowindex = ElementTableIndex(atributelist.get(zzz).getName(), 0);
                                if (atributerowindex != -1) {
                                    MainWindow.XMLTable[currenttableindex].setValueAt(atributelist.get(zzz).getValue(),
                                    MainWindow.XMLTableActiveRowIndex[currenttableindex], atributerowindex);
                                }
                            }
                        }


                        FillTables(activee.getChildren(), previoustableindex);
                        currenttableindex = previoustableindex;
                        previoustableindex = bpti;

                    //SearchTableName(activee.getName().toString());


                }
                if (elementrowindex >= (MainWindow.XMLTable[currenttableindex].getColumnCount() - 1)) {
                    
                    //prida sa novy riadok
                    if (i > 0) {
                    if (MainWindow.XMLTableModel[currenttableindex].getColumnName(elementrowindex).compareTo(xlist.get(i - 1).getName().toString()) == 0) {

                    } else {
                        //prida sa novy riadok*/
                        MainWindow.XMLTableActiveRowIndex[currenttableindex]++;
                    String[] emptyline = {""};
                    MainWindow.XMLTableModel[currenttableindex].addRow(emptyline);
                    }
                    } else {
                         MainWindow.XMLTableActiveRowIndex[currenttableindex]++;
                    String[] emptyline = {""};
                    MainWindow.XMLTableModel[currenttableindex].addRow(emptyline);
                    }
                    // este nieco

                }
                // TODO vracanie sa naspak ? wtf? ak je to posledny element nevykresluje dalej tabulky ... kek...
                /*if (elementrowindex > 0) {
                    if (MainWindow.XMLTableModel[currenttableindex].getColumnName(elementrowindex - 1).toString().compareTo(
                        MainWindow.XMLTableModel[currenttableindex].getColumnName(elementrowindex).toString()) == 0) {
                            MainWindow.XMLTableActiveRowIndex[currenttableindex]--;
                            MainWindow.XMLTableModel[currenttableindex].removeRow(MainWindow.XMLTableActiveRowIndex[currenttableindex] + 1);
                    }
                }*/
                //FillTables(activee.getChildren());
            
            }
           /* if (MainWindow.XMLTableModel[currenttableindex].getColumnName(elementrowindex - 1).toString().compareTo(
                    MainWindow.XMLTableModel[currenttableindex].getColumnName(elementrowindex).toString()) == 0) {
                        MainWindow.XMLTableActiveRowIndex[currenttableindex]--;
                        MainWindow.XMLTableModel[currenttableindex].removeRow(MainWindow.XMLTableActiveRowIndex[currenttableindex]+1);
            }*/
        }

    }

    /**
     * Metoda ktora vrati index tabulky podla mena
     *
     * @param tname meno tabulky
     * @return index tabulky
     */
    public static int SearchTableName(String tname) {
        int returnval = -1;
        for (int i = 0; i < MainWindow.XMLTableCount; i++) {
            if (MainWindow.XMLTableName[i].compareTo(tname) == 0) {
                returnval = i;
                break;
            }
        }
        return returnval;
    }

    /**
     * Metoda ktora vrati index najblizsieho prazdneho elementu v riadku podla nazvu
     *
     * @param ename nazov elemenetu
     * @return index elementu
     */
    public static int ElementTableIndex(String ename, int parentindex) {
        int returnval = -1;
        /*if (MainWindow.XMLTableModel[currenttableindex].getColumnName(0).compareTo(ename) == 0) {
            returnval = 0;
        } else {
        */

        for (int i = parentindex; i < MainWindow.XMLTable[currenttableindex].getColumnCount(); i++) {
            if (MainWindow.XMLTable[currenttableindex].getColumnName(i).compareTo(ename) == 0) {
                if (MainWindow.XMLTable[currenttableindex].getValueAt(MainWindow.XMLTableActiveRowIndex[currenttableindex], i) == null) {
                    returnval = i;
                    break;
                }
                if (MainWindow.XMLTable[currenttableindex].getValueAt(MainWindow.XMLTableActiveRowIndex[currenttableindex], i) == "") {
                    returnval = i;
                    break;
                }
                // naslo ho ale uz bol plny
                //returnval = -2;
            }
        }
        //}
        return returnval;
    }


    /**
     * Metoda, ktora vytvara stlpce tabulky podla schemy
     *
     * @param clist zoznam elementov na aktualnej urovni stromu
     */
    public static void ChildrenListHandle(List<Element> clist) {
        int listsize = clist.size();
        List<Element> onechild;
        int iterationcounter = 0;
        Element parentelement;
        String referencename = "";
        int referencedindex = -1;
        List<Element> firstlevel_attributelist;
        List<Element> secondlevel_attributelist;
        List<Element> thirdlevel_attributelist;
        List<Element> attributelist = new LinkedList();
        boolean maketable = false;
        String prefixandname = "";
        boolean isparenttable = false;
        boolean isrefered = false;
        String[] onename = new String[1];
        int referednumber = 0;
        String backupstring = "";


        try {
        for (int i = 0; i < listsize; i++) {
            iterationcounter++;
            if (clist.get(i).getName().toLowerCase().compareTo("element") == 0) { // ak je to element
                                    parentelement = clist.get(i).getParentElement();
                    if (parentelement.getName().toLowerCase().compareTo("oneormore") == 0) {
                        maketable=true;
                    }
                if (onnextcreatetable && maketable) { // predtym bolo oneormore
                    prefixandname = clist.get(i).getAttributeValue("name").toString();
                    onename[0] = prefixandname;
                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addColumn(prefixandname, onename);
                    CreateTable(clist.get(i).getAttributeValue("name").toString()); // nova tabulka
                    // do novej tabulky na zaciatok sa vlozi ten isty element, kvoli referencii
                    String[] cleanline = {""};
                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addRow(cleanline);
                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addColumn(prefixandname, onename);
                    MainWindow.XMLTableActiveRowIndex[MainWindow.XMLTableIndex]++;
                    //MainWindow.XMLTableModel[MainWindow.XMLTableIndex].setValueAt(prefixandname, 0, 0);
                    // velmi pravdepodobne ze elementy tvoriace tabulku budu mat dake atributy
                    firstlevel_attributelist = new LinkedList(clist.get(i).getChildren());
                    // max 2x <group> tag tam moze byt jeden pre attributy a jeden pre sekvenciu zastresovanu tymto elementom
// ===== start: PARSER ATTRIBUTOV ELEMENTU!!!
                    if (firstlevel_attributelist.size() != 0) { // uistime sa ze list je neprazdny
                        if (firstlevel_attributelist.get(0).getName().toLowerCase().compareTo("group") == 0) {
                            //ak sa naslo <group>
                            secondlevel_attributelist = new LinkedList(firstlevel_attributelist.get(0).getChildren());
                            // child elementy <group> su v secondlevel liste
                            if (secondlevel_attributelist.size() != 0) { // zasa je list neprazdny?
                                if (secondlevel_attributelist.get(0).getName().toLowerCase().compareTo("group") == 0) {
                                    // naslo sa <group> <group>, tretie musi byt <attribute>
                                    thirdlevel_attributelist = new LinkedList(secondlevel_attributelist.get(0).getChildren());
                                     if (secondlevel_attributelist.size() != 0) { //list je neprazdny ?
                                        if (thirdlevel_attributelist.get(0).getName().toLowerCase().compareTo("attribute") == 0) {
                                            // bingo nasli sme zanorene attributy
                                            //attributelist = new LinkedList();
                                            int ii = 0;
                                            for (int q = 0; q < thirdlevel_attributelist.size(); q++) {
                                                if (thirdlevel_attributelist.get(q).getName().toLowerCase().compareTo("attribute") == 0) {
                                                    attributelist.add(ii, thirdlevel_attributelist.get(q));
                                                    ii++;
                                                }
                                            }
                                        } else {
                                            //attributelist = null; // nenaslo sa ani tu <attribute>, uzatvarame, ze element nema attributy
                                        }
                                     } else {
                                        //attributelist = null; // v liste sa nic nenaslo, niesu attributy
                                     }
                                } else if (secondlevel_attributelist.get(0).getName().toLowerCase().compareTo("attribute") == 0) {
                                    // bingo nasli sme zanorene attributy
                                    //attributelist = new LinkedList();
                                    int ii = 0;
                                    for (int q = 0; q < secondlevel_attributelist.size(); q++) {
                                        if (secondlevel_attributelist.get(q).getName().toLowerCase().compareTo("attribute") == 0) {
                                            attributelist.add(ii, secondlevel_attributelist.get(q));
                                            ii++;
                                        }
                                    }
                                } else {
                                    // nenasli sme attribute, takze neexistuju
                                    //attributelist = null;
                                }
                            } else {
                                // list prazdny, nic zas...
                                //attributelist = null;
                            }
                        } else if (firstlevel_attributelist.get(0).getName().toLowerCase().compareTo("attribute") == 0) {
                            // naslo sa hned <attribute> - nemalo by nastat, ale co ak?
                            //attributelist = new LinkedList();
                            int ii = 0;
                            for (int q = 0; q < firstlevel_attributelist.size(); q++) {
                                if (firstlevel_attributelist.get(q).getName().toLowerCase().compareTo("attribute") == 0) {
                                    attributelist.add(ii, firstlevel_attributelist.get(q));
                                    ii++;
                                }
                            }
                        } else {
                            //attributelist = null;
                        }
                    } else {
                        // list prazdny, nic uz po 10-ty krat...
                        //attributelist = null;
                    }
// ======= end: PARSER ATTRIBUTOV ELEMENTU!!!
                    // vlozenie listu attributov rodicovskeho elementu ( nazvu tabulky ) do tabulky
                    //if ((attributelist != null) || (attributelist.size() != 0)) {
                    if (attributelist.size() != 0) {
                        for (int qq = 0; qq < attributelist.size(); qq++) {

                    prefixandname = attributelist.get(qq).getAttributeValue("name").toString();
                    onename[0] = "a: " + prefixandname;
                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addColumn(prefixandname, onename);
                    //prefixandname = "a: " + prefixandname;
                    //MainWindow.XMLTableModel[MainWindow.XMLTableIndex].setValueAt(prefixandname, 0, qq+1);
                        }
                    }
                    onnextcreatetable = false; // zrusit priznak
                    onechild = clist.get(i).getChildren(); // zoznam deti
                    ChildrenListHandle(onechild);
                        MainWindow.XMLTableIndex = MainWindow.XMLTableIndex - 1;
                } else { // klasicky pripad, nenastalo oneormore
                    prefixandname = clist.get(i).getAttributeValue("name").toString();
                    onename[0] = prefixandname;
                    

                    // treba metodu kvoli referenciam ...
                    // zistenie otca, az niekolko krat zaloreny
                    parentelement = clist.get(i).getParentElement();
                    if (parentelement.getName().toLowerCase().compareTo("define") == 0)
                        isrefered = true;
                    if (parentelement.getName().toLowerCase().compareTo("element") == 0) {
                       // nasli sme otca
                    } else if (parentelement.getParentElement() != null) {
                        parentelement = parentelement.getParentElement();
                        if (parentelement.getName().toLowerCase().compareTo("define") == 0)
                            isrefered = true;
                        // druha uroven
                        if (parentelement.getName().toLowerCase().compareTo("element") == 0) {
                           // nasli sme otca
                        } else if (parentelement.getParentElement() != null) {
                            parentelement = parentelement.getParentElement();
                            if (parentelement.getName().toLowerCase().compareTo("define") == 0)
                                isrefered = true;
                            // tretia uroven
                            if (parentelement.getName().toLowerCase().compareTo("element") == 0) {
                               // nasli sme otca
                            } else if (parentelement.getParentElement() != null) {
                                parentelement = parentelement.getParentElement();
                                if (parentelement.getName().toLowerCase().compareTo("define") == 0)
                                    isrefered = true;
                                // stvrta uroven
                                if (parentelement.getName().toLowerCase().compareTo("element") == 0) {
                                   // nasli sme otca
                                } else {
                                    parentelement = null;
                                }
                            }
                        }
                    }


                    if (isrefered) {
                        onename[0] = "*." + prefixandname;
                        /*referednumber = MainWindow.XMLTableModel[MainWindow.XMLTableIndex].getColumnCount();
                        backupstring = MainWindow.XMLTableModel[MainWindow.XMLTableIndex].getValueAt(0, referednumber-1).toString();
                        referednumber = backupstring.indexOf('.');
                        if (referednumber == -1) {
                            onename[0] = backupstring + "." + prefixandname;
                        } else {
                            if (backupstring.indexOf("a:") != -1) {
                                onename[0] = prefixandname;
                            } else {
                                onename[0] = backupstring.substring(0, referednumber) + "." + prefixandname;
                            }
                        }*/
                    }
                    if (parentelement != null) {
                        if (parentelement.getName().toLowerCase().compareTo("element") == 0) {
                           // mame otca

                            for (int zz = 0; zz < MainWindow.XMLTableCount; zz++) {
                                if (parentelement.getAttributeValue("name").toLowerCase().compareTo(MainWindow.XMLTableName[zz]) == 0) {
                                    isparenttable = true;
                                }

                            }
                            if (!isparenttable) {
                                onename[0] = parentelement.getAttributeValue("name").toString() + "." + prefixandname;
                            }
                        }
                    }

                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addColumn(prefixandname, onename);
                    isparenttable = false;
                    isrefered = false;

                    onechild = clist.get(i).getChildren(); // zoznam deti
                    if ((onechild.size() == 1) && (onechild.get(0).getName().toLowerCase().compareTo("text") == 0)) { // ak ma len 1 dieta a je to text
                        // do nothing - nezanoruj sa
                    } else {
                        ChildrenListHandle(onechild); // zanoruje sa dalej
                    }
                }
                /*if (i == (listsize - 1)) {  // ak je rodicom oneormore - konci sekvencia tabuliek
                    parentelement = clist.get(i).getParentElement();
                    if (parentelement.getName().toLowerCase().compareTo("oneormore") == 0) {
                        MainWindow.XMLTableIndex = MainWindow.XMLTableIndex - 1;
                    }
                }*/
            
            } else if (clist.get(i).getName().toLowerCase().compareTo("ref") == 0) { // ak je to referencny element
                //referencename = clist.get(i).getAttribute("name").toString();
                referencedindex = -1;
                String searchedname = clist.get(i).getAttributeValue("name");

                // kedze sa objavilo ref, tak musi byt nieco v reference liste, a musi toho byt viac ako <start> tag
                for (int z = 1; z < referencenamelist.size(); z++) { // hladanie mena
                    if (referencenamelist.get(z).getAttributeValue("name").compareTo(searchedname) == 0) {
                        referencedindex = z;
                    }
                }
                try {
                    if (referencedindex != -1) {
                        onechild = referencenamelist.get(referencedindex).getChildren();
                        ChildrenListHandle(onechild);
                        //referencename = referencenamelist.get(referencedindex).getAttributeValue("name");
                    } else { // nemalo by nastat
                        Exception ex = new Exception();
                        throw ex;
                    }
                } catch (Exception ex) {
                    MainWindow.ShowMessage("ERROR!", "Reference error within schema file!\n Visualization cancelled.");
                }

                /*if (onnextcreatetable) { // predtym bolo oneormore
                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addColumn(referencename);
                    CreateTable(referencename); // nova tabulka
                    onnextcreatetable = false; // zrusit priznak
                    onechild = clist.get(i).getChildren(); // zoznam deti
                    ChildrenListHandle(onechild);
                } else { // klasicky pripad, nenastalo oneormore
                    MainWindow.XMLTableModel[MainWindow.XMLTableIndex].addColumn(referencename);
                    onechild = clist.get(i).getChildren(); // zoznam deti
                    if ((onechild.size() == 1) && (onechild.get(0).getName().toLowerCase().compareTo("text") == 0)) { // ak ma len 1 dieta a je to text
                        // do nothing - nezanoruj sa
                    } else {
                        ChildrenListHandle(onechild); // zanoruje sa dalej
                    }
                }*/
                if (i == (listsize - 1)) {  // ak je rodicom oneormore - konci sekvencia tabuliek
                    parentelement = clist.get(i).getParentElement();
                    if (parentelement.getName().toLowerCase().compareTo("oneormore") == 0) {
                        MainWindow.XMLTableIndex = MainWindow.XMLTableIndex - 1;
                    }
                }
            } else if (clist.get(i).getName().toLowerCase().compareTo("oneormore") == 0) { // ak je to oneormore tag - nova tabulka
                onnextcreatetable = true;
                onechild = clist.get(i).getChildren(); // zoznam deti
                ChildrenListHandle(onechild);
            /*} else if (clist.get(i).getName().toLowerCase().compareTo("group") == 0) { // ak je to group tag - nova tabulka
                onnextcreatetable = true;
                onechild = clist.get(i).getChildren(); // zoznam deti
                ChildrenListHandle(onechild);*/
            } else { // ak to je nejaky iny tag
                onechild = clist.get(i).getChildren(); // zoznam deti
                ChildrenListHandle(onechild);
            }
        
        }
        } catch (Exception ex) {
            MainWindow.ShowMessage("ERROR!", "Error in schema file!\n Visualization cancelled.");
        }

    }
    
    /**
     * Vytvori tabulku s nazvom tablename
     *
     * @param tablename nazov tabulky
     */
    public static void CreateTable(String tablename) {
        
        MainWindow.XMLTableCount = MainWindow.XMLTableCount + 1;
        MainWindow.XMLTableIndex = MainWindow.XMLTableIndex + 1;
        MainWindow.XMLTableName[MainWindow.XMLTableIndex] = tablename;
        MainWindow.XMLTableModel[MainWindow.XMLTableIndex] = new DynamicTableModel();


    }
    
    /**
     * Naformatuje tabulku podla indexu
     *
     * @param tableindex index formatovanej tabulky
     */
    public static void AddFormatViewTable(int tableindex) {
        MainWindow.XMLTable[tableindex] = new JTable(MainWindow.XMLTableModel[tableindex]);
        MainWindow.XMLTable[tableindex].setFont(TableFont);
        MainWindow.XMLTable[tableindex].setForeground(FgColor);
        MainWindow.XMLTable[tableindex].setBackground(BgColor);
        MainWindow.XMLTable[tableindex].setRowMargin(2);
        MainWindow.XMLTable[tableindex].setColumnSelectionAllowed(false);
        MainWindow.XMLTable[tableindex].setRowSelectionAllowed(false);
        MainWindow.XMLTable[tableindex].getTableHeader().setReorderingAllowed(false);
        MainWindow.XMLTable[tableindex].getTableHeader().setBackground(HeaderBgColor);
        MainWindow.XMLTable[tableindex].getTableHeader().setForeground(HeaderFgColor);
        //MainWindow.XMLTable[tableindex].getTableHeader().setResizingAllowed(false);
        //MainWindow.XMLTable[tableindex].setSelectionBackground(SelectionBgColor);
        //MainWindow.XMLTable[tableindex].setSelectionForeground(SelectionFgColor);
        MainWindow.XMLTable[tableindex].setGridColor(GridColor);
        MainWindow.XMLTable[tableindex].setRowHeight(20);
        MainWindow.XMLTable[tableindex].setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        //MainWindow.XMLTable[tableindex].setSelectionModel(SelModel);
        MainWindow.XMLTable[tableindex].setEnabled(true);
        MainWindow.XMLTableScroller[tableindex] = new JScrollPane(MainWindow.XMLTable[tableindex]);
        //MainWindow.XMLTableScroller[tableindex].add(MainWindow.XMLTable[tableindex], BorderLayout.CENTER);
        //MainWindow.XMLTableScroller[tableindex].add(MainWindow.XMLTable[tableindex].getTableHeader(), BorderLayout.NORTH);
        //MainWindow.XMLTableScroller[tableindex].setViewportView(MainWindow.XMLTable[tableindex]);
        MainWindow.VisualizeTabsPane.addTab(MainWindow.XMLTableName[tableindex], MainWindow.XMLTableScroller[tableindex]);
        MainWindow.VisualizeTabsPane.setEnabledAt(tableindex, true);

    }
    
}
