/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package base;

import base.*;

import java.io.*;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import org.dom4j.*;
import org.dom4j.io.*;
import org.jdom.*;
import org.jdom.input.SAXBuilder;
import org.apache.commons.io.IOUtils;

/**
 *
 * @author illi
 */
public class XSDHandler {

    private static SAXBuilder saxBuilder;
    private static boolean validate = false;
    private static BufferedReader reader;
    private static byte[] xml = new byte[] {};
    
    /**
     * Metoda ktora nacita dokument z daneho URL
     * 
     * @param url cesta k dokumentu
     * @return vracia xml dokument
     * @throws org.dom4j.DocumentException - ked je problem s dokumentom
     */
    public static org.jdom.Document readDocument(String path) throws Exception {
        saxBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        /*reader = new BufferedReader(new FileReader(new File(path)));
        xml = IOUtils.toByteArray(reader);*/
        URL url = new File(path).toURL();
        org.jdom.Document document = saxBuilder.build(url);
        return document;
    }

    /**
     * Metoda ktora nacita dany subor
     * 
     * @param file subor ktory cita
     * @return vracia string s obsahom dokumentu
     */
    public static String readFile(File file) throws Exception {
        StringBuilder contents = new StringBuilder();


            BufferedReader input = new BufferedReader(new FileReader(file));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            } finally {
                input.close();
            }

        return contents.toString();

    }

    /**
     * Metoda ktora dany dokument naformatuje do stringu
     * 
     * @param doc dokument z ktoreho sa nacitava
     * @return string ktory obsahuje naformatovany dokument
     */
    static public String docToString(String doc) {
        StringBuilder sb = new StringBuilder();
                
        try {
            BufferedReader breader = new BufferedReader(new FileReader(new File(doc)));
            String line = "";
            while((line = breader.readLine()) != null) {
                sb.append(line + "\n");
            }
            breader.close();
            return sb.toString();
        } catch (Exception e) {
            MainWindow.ShowMessage("ERROR!","Unable to load XML document!");
            return "";
        } 
    }

    /**
     * Zápis stringu do suboru
     * @param string string nacitany z okna
     * @throws java.io.IOException
     */
    public static void writeFromString(String string) throws IOException {
        /*String t = ".xml";
        if (MainWindow.XMLpath.substring(MainWindow.XMLpath.length() - 4).compareTo(t) != 0) {
        MainWindow.XMLpath += t;
        }*/
        BufferedWriter out = new BufferedWriter(new FileWriter(MainWindow.XSDpath));
        out.write(string);
        out.close();
    }
}
