/*
 * XPropertiesFrame.java
 *
 * Created on 25. duben 2009, 17:12
 */

package base;

import base.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author  illi
 */
public class XPropertiesFrame extends javax.swing.JDialog {

    /** Creates new form XPropertiesFrame */
    public XPropertiesFrame() {
        initComponents();
        newXMLColor = MainWindow.XMLColor;
        newXSDColor = MainWindow.XSDColor;
        newSchemaOutputFormat = MainWindow.SchemaOutputFormat;
        PropertiesFrameXMLColorButton.setBackground(newXMLColor);
        PropertiesFrameXSDColorButton.setBackground(newXSDColor);
        PropertiesFrameXSDFormatCombo.setSelectedIndex(newSchemaOutputFormat);
        
        PropertiesFrameButtonOK.registerKeyboardAction(
        new DefaultAction((AbstractButton) PropertiesFrameButtonOK),
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false),
            JComponent.WHEN_IN_FOCUSED_WINDOW);
        PropertiesFrameButtonCancel.registerKeyboardAction(
        new DefaultAction((AbstractButton) PropertiesFrameButtonCancel),
            KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false),
            JComponent.WHEN_IN_FOCUSED_WINDOW);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        PropertiesFrameLabel1 = new javax.swing.JLabel();
        PropertiesFrameLabel2 = new javax.swing.JLabel();
        PropertiesFrameLabel3 = new javax.swing.JLabel();
        PropertiesFrameXMLColorButton = new javax.swing.JButton();
        PropertiesFrameXSDColorButton = new javax.swing.JButton();
        PropertiesFrameXSDFormatCombo = new javax.swing.JComboBox();
        PropertiesFrameButtonOK = new javax.swing.JButton();
        PropertiesFrameButtonCancel = new javax.swing.JButton();
        PropertiesFrameButtonDefault = new javax.swing.JButton();
        PropertiesFrameDisplayCombo = new javax.swing.JComboBox();
        PropertiesFrameLabel4 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Properties");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        PropertiesFrameLabel1.setText("XML Text Color");
        PropertiesFrameLabel1.setName("PropertiesFrameLabel1"); // NOI18N

        PropertiesFrameLabel2.setText("Schema Text Color");
        PropertiesFrameLabel2.setName("PropertiesFrameLabel2"); // NOI18N

        PropertiesFrameLabel3.setText("Schema Format");
        PropertiesFrameLabel3.setName("PropertiesFrameLabel3"); // NOI18N

        PropertiesFrameXMLColorButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        PropertiesFrameXMLColorButton.setMaximumSize(new java.awt.Dimension(30, 30));
        PropertiesFrameXMLColorButton.setMinimumSize(new java.awt.Dimension(30, 30));
        PropertiesFrameXMLColorButton.setName("[30, 30]"); // NOI18N
        PropertiesFrameXMLColorButton.setPreferredSize(new java.awt.Dimension(30, 30));
        PropertiesFrameXMLColorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PropertiesFrameXMLColorButtonActionPerformed(evt);
            }
        });

        PropertiesFrameXSDColorButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        PropertiesFrameXSDColorButton.setMaximumSize(new java.awt.Dimension(30, 30));
        PropertiesFrameXSDColorButton.setMinimumSize(new java.awt.Dimension(30, 30));
        PropertiesFrameXSDColorButton.setName("PropertiesFrameXSDColorButton"); // NOI18N
        PropertiesFrameXSDColorButton.setPreferredSize(new java.awt.Dimension(30, 30));
        PropertiesFrameXSDColorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PropertiesFrameXSDColorButtonActionPerformed(evt);
            }
        });

        PropertiesFrameXSDFormatCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "rng", "rnc", "xsd", "dtd" }));
        PropertiesFrameXSDFormatCombo.setName("PropertiesFrameXSDFormatCombo"); // NOI18N

        PropertiesFrameButtonOK.setText("OK");
        PropertiesFrameButtonOK.setName("PropertiesFrameButtonOK"); // NOI18N
        PropertiesFrameButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PropertiesFrameButtonOKActionPerformed(evt);
            }
        });

        PropertiesFrameButtonCancel.setText("Cancel");
        PropertiesFrameButtonCancel.setName("PropertiesFrameButtonCancel"); // NOI18N
        PropertiesFrameButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PropertiesFrameButtonCancelActionPerformed(evt);
            }
        });

        PropertiesFrameButtonDefault.setText("Default");
        PropertiesFrameButtonDefault.setName("PropertiesFrameButtonDefault"); // NOI18N
        PropertiesFrameButtonDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PropertiesFrameButtonDefaultActionPerformed(evt);
            }
        });

        PropertiesFrameDisplayCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "XML and Schema", "Schema only", "Visualization only" }));
        PropertiesFrameDisplayCombo.setName("PropertiesFrameDisplayCombo"); // NOI18N

        PropertiesFrameLabel4.setText("Display Mode");
        PropertiesFrameLabel4.setName("PropertiesFrameLabel4"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(PropertiesFrameLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE)
                    .addComponent(PropertiesFrameLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(PropertiesFrameXSDColorButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(PropertiesFrameXMLColorButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PropertiesFrameButtonDefault)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 42, Short.MAX_VALUE)
                .addComponent(PropertiesFrameButtonOK)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(PropertiesFrameButtonCancel)
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(PropertiesFrameLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, 103, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addComponent(PropertiesFrameDisplayCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(PropertiesFrameLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, 150, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addComponent(PropertiesFrameXSDFormatCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 59, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(PropertiesFrameLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 30, Short.MAX_VALUE)
                    .addComponent(PropertiesFrameXMLColorButton, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(PropertiesFrameLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 30, Short.MAX_VALUE)
                    .addComponent(PropertiesFrameXSDColorButton, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(PropertiesFrameLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(PropertiesFrameXSDFormatCombo))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(PropertiesFrameLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(PropertiesFrameDisplayCombo))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(PropertiesFrameButtonCancel)
                    .addComponent(PropertiesFrameButtonOK)
                    .addComponent(PropertiesFrameButtonDefault))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void PropertiesFrameXMLColorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PropertiesFrameXMLColorButtonActionPerformed
    newXMLColor = JColorChooser.showDialog(this, "Choose a color for XML document text", MainWindow.XMLColor);
    PropertiesFrameXMLColorButton.setBackground(newXMLColor);
}//GEN-LAST:event_PropertiesFrameXMLColorButtonActionPerformed

private void PropertiesFrameXSDColorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PropertiesFrameXSDColorButtonActionPerformed
    newXSDColor = JColorChooser.showDialog(this, "Choose a color for XML schema text", MainWindow.XSDColor);
    PropertiesFrameXSDColorButton.setBackground(newXSDColor);
}//GEN-LAST:event_PropertiesFrameXSDColorButtonActionPerformed

private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    this.setVisible(false);
    MainWindow.EnableMainWindow();
}//GEN-LAST:event_formWindowClosing

private void PropertiesFrameButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PropertiesFrameButtonOKActionPerformed
    this.setVisible(false);
    MainWindow.XMLColor = newXMLColor;
    MainWindow.XSDColor = newXSDColor;
    MainWindow.SchemaOutputFormat = PropertiesFrameXSDFormatCombo.getSelectedIndex();
    MainWindow.DisplayMode = PropertiesFrameDisplayCombo.getSelectedIndex();
    MainWindow.ApplyConfigChanges();
    if (MainWindow.XMLdocOpened || MainWindow.XSDdocOpened || MainWindow.XSDdocGenerated) {
        // do nothing
    } else {
        MainWindow.SetDisplayMode();
    }
    /*if (MainWindow.XSDdocGenerated || MainWindow.XSDdocOpened) {
        MainWindow.XSDClosed();
    }*/
    MainWindow.XSDFileChooserSetExtension(MainWindow.SchemaOutputFormat);
    MainWindow.EnableMainWindow();
}//GEN-LAST:event_PropertiesFrameButtonOKActionPerformed

private void PropertiesFrameButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PropertiesFrameButtonCancelActionPerformed
    this.setVisible(false);
    MainWindow.EnableMainWindow();
}//GEN-LAST:event_PropertiesFrameButtonCancelActionPerformed

private void PropertiesFrameButtonDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PropertiesFrameButtonDefaultActionPerformed
    newXMLColor = new Color(0, 0, 0);
    PropertiesFrameXMLColorButton.setBackground(newXMLColor);
    newXSDColor = new Color(0, 80, 0);
    PropertiesFrameXSDColorButton.setBackground(newXSDColor);
    newSchemaOutputFormat = 0;
    PropertiesFrameXSDFormatCombo.setSelectedIndex(newSchemaOutputFormat);
    if (MainWindow.XMLdocOpened || MainWindow.XSDdocOpened || MainWindow.XSDdocGenerated) {
        // do nothing
    } else {
        newDisplayMode = 0;
        PropertiesFrameDisplayCombo.setSelectedIndex(newDisplayMode);
    }
}//GEN-LAST:event_PropertiesFrameButtonDefaultActionPerformed


public void SetProperties (Color color1, Color color2, int formatno, int displaymod) {
    newXMLColor = color1;
    PropertiesFrameXMLColorButton.setBackground(newXMLColor);
    newXSDColor = color2;
    PropertiesFrameXSDColorButton.setBackground(newXSDColor);
    newSchemaOutputFormat = formatno;
    PropertiesFrameXSDFormatCombo.setSelectedIndex(newSchemaOutputFormat);
    newDisplayMode = displaymod;
    PropertiesFrameDisplayCombo.setSelectedIndex(newDisplayMode);
}

public void ToggleDisplayModeChange(boolean change) {
    PropertiesFrameDisplayCombo.setEnabled(change);
}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private static javax.swing.JButton PropertiesFrameButtonCancel;
    private static javax.swing.JButton PropertiesFrameButtonDefault;
    private static javax.swing.JButton PropertiesFrameButtonOK;
    private static javax.swing.JComboBox PropertiesFrameDisplayCombo;
    private static javax.swing.JLabel PropertiesFrameLabel1;
    private static javax.swing.JLabel PropertiesFrameLabel2;
    private static javax.swing.JLabel PropertiesFrameLabel3;
    private static javax.swing.JLabel PropertiesFrameLabel4;
    private static javax.swing.JButton PropertiesFrameXMLColorButton;
    private static javax.swing.JButton PropertiesFrameXSDColorButton;
    private static javax.swing.JComboBox PropertiesFrameXSDFormatCombo;
    // End of variables declaration//GEN-END:variables

    private static Color newXMLColor = null;
    private static Color newXSDColor = null;
    private static int newSchemaOutputFormat = 0;
    private static int newDisplayMode = 0;
    
}
