
package base;

import base.*;

import java.io.File;
import java.lang.reflect.Method;

/**
 * Trieda pomocou ktorej sa nacítava help (html dokument)
 * 
 * @author Martin Seko
 * @author <a href="mailto:xsekom00@fit.vutbr.cz">xsekom00@fit.vutbr.cz</a>
 */

public class HelpContents {
    
    private String url;
    /** 
     * Konstruktor - Vytvorí novu instanciu triedy
     * 
     * @param u cesta k nápovede na disku.
     */
    public HelpContents(String u) {
        url = u;
    }
    
    /** 
     * Otvorí súbor zadaný v parametri u konstruktora
     *
     * @see #HelpContents
     */
    public void Open() {
        File file = new File(url);
        String path = file.getAbsolutePath();
        String osName = System.getProperty("os.name");
        try {
            // Windows
            if (osName.startsWith("Windows"))
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + path);
            // Mac Os
            else if (osName.startsWith("Mac OS")) {
                Class fileMngr = Class.forName("com.apple.eio.FileManager");
                Method open = fileMngr.getDeclaredMethod("openURL", new Class[] {String.class});
                open.invoke(null, new Object[] {path});
            // Linux
            } else {
                String[] browsers = { "firefox", "mozilla", "netscape", "opera", "konqueror"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; count++)
                    if (Runtime.getRuntime().exec(new String[] {"which", browsers[count]}).waitFor() == 0)
                        browser = browsers[count];
                    if (browser != null)
                        Runtime.getRuntime().exec(new String[] {browser, path});
            }
            // keby nastala vynimka
        } catch (Exception ex) {
            MainWindow.ShowMessage("ERROR!","Unable to load Help Contents File!");
            return;
        }
    }
}
