//-----------------------------------------------------------------------------
// imagetools.h
// Image representation and low level image manipulation
// Roman Juranek, DCGM FIT BUT, Brno
// $Id$
//-----------------------------------------------------------------------------


#ifndef _ImageTools_H_
#define _ImageTools_H_


#include <cv.h>
#include <cxcore.h>
#include <vector>


// Interleaved convolution
struct TConvolution
{
    signed char * image; // data pointer

	unsigned cw, ch; // width ad height of convolution kernel
    unsigned rowStep; // step between interleaved rows
    unsigned blockStep; // step between blocks 
    unsigned rows; // number of rows (experimental!!!)
    CvSize srcSz;

    signed char ** block; // index of blocks
    int * row; // row offsets

    TConvolution(CvSize sz, int x, int y);

    ~TConvolution()
    {
        
        if (image) delete [] image;
        delete [] block;
        delete [] row;
    }

    
}; // TConvolution


/// Structure to index image rows.
/// Can be used to avoid multiplication in pixel access
class TImageRowIndex
{
    IplImage * image;
    std::vector<char*> index;
public:

    TImageRowIndex(IplImage * img)
        :image(img), index(img->height)
    {
        index[0] = img->imageData;
        for (int i = 1; i < img->height; ++i)
        {
            index[i] = index[i-1] + img->widthStep;
        }
    }

    const char * operator[](int i) const
    {
        return index[i];
    }

    char * operator[](int i) 
    {
        return index[i];
    }
};


/// General convolution function.
void convolution(IplImage * integral, TConvolution * conv);

/// Calculate four convolution simultaneouly.
/// Convolutions 1x1, 2x2, 1x2 and 2x1 are calculated.
/// \param image Image to process
/// \param conv11 1x1 convoution image
/// \param conv22 2x2 convoution image
/// \param conv12 1x2 convoution image
/// \param conv21 2x1 convoution image
void convolution12(IplImage * image, TConvolution * conv11, TConvolution * conv22, TConvolution * conv12, TConvolution * conv21);

void convolve12all(IplImage * image, std::vector<TConvolution*> & conv);

/// Integrate image.
/// Calculates two different integral images - sum of original values
/// and sum of its squares to accelerate calculation of subwindow standard
/// deviation.
/// \param image Input image
/// \param sum Integral image
/// \param sum2 Integral image
void integrate(IplImage * image, IplImage * int1, IplImage * int2);

/// Integrate image.
/// Calculates ordinary integral image
/// \param image Input image
/// \param sum Integral image
void integrate(IplImage * image, IplImage * int1);


#endif
