/*
 * Constants required for LRD evaluation
 * $Id$
 * 
 * This data are valid ONLY for LRD classifiers with convolution sizes up to 2x2
 */

//
// Each table row corresponds to different modulo shift of
// a sample in image (with modulo 4 - position type).
// Each row is 4x4 table corresponding to different
// modulo shift of a feature within a sample.
//

// size type - 000000{h-1}{w-1}
// 00 - 1x1px
// 01 - 2x1px
// 10 - 1x2px
// 11 - 2x2px


#include "lrd_const.h"

//using namespace std;


// Block table
// 4 tables for different convolution type
// 16 tables for sample pos type
// 16 values for feature pos within sample
// 
// 10 bit index to the table:
// 2b - sz type << 8
// 4b - sample posType << 4
// 4b - feature posType

const unsigned char  blockTable[1024] =
{
    // type 0 (1x1) table - all blocks are 0
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
    
    // type 1 (2x1) table
    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,

    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,

    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,

    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
    0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1, 
    1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,

    // type 2 (1x2) table
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,
    
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  
    1, 1, 1, 1,  0, 0, 0, 0,  1, 1, 1, 1,  0, 0, 0, 0,  

    // type 3 (2x2) table
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
    
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
}; // blockTable


// mask index for different positions of feature and sample
const unsigned char maskTable[1024] =
{
    // 0,0 shift
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
    
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,
    1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,
    
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  
    2, 3, 2, 3,  0, 1, 0, 1,  2, 3, 2, 3,  0, 1, 0, 1,  
    3, 2, 3, 2,  1, 0, 1, 0,  3, 2, 3, 2,  1, 0, 1, 0,  

    // 1,0 shift
    0, 0, 1, 1,  2, 2, 3, 3,  0, 0, 1, 1,  2, 2, 3, 3,
    0, 1, 1, 0,  2, 3, 3, 2,  0, 1, 1, 0,  2, 3, 3, 2,
    1, 1, 0, 0,  3, 3, 2, 2,  1, 1, 0, 0,  3, 3, 2, 2,
    1, 0, 0, 1,  3, 2, 2, 3,  1, 0, 0, 1,  3, 2, 2, 3,

    2, 2, 3, 3,  0, 0, 1, 1,  2, 2, 3, 3,  0, 0, 1, 1,  
    2, 3, 3, 2,  0, 1, 1, 0,  2, 3, 3, 2,  0, 1, 1, 0,  
    3, 3, 2, 2,  1, 1, 0, 0,  3, 3, 2, 2,  1, 1, 0, 0,  
    3, 2, 2, 3,  1, 0, 0, 1,  3, 2, 2, 3,  1, 0, 0, 1,  
    
    0, 0, 1, 1,  2, 2, 3, 3,  0, 0, 1, 1,  2, 2, 3, 3,
    0, 1, 1, 0,  2, 3, 3, 2,  0, 1, 1, 0,  2, 3, 3, 2,
    1, 1, 0, 0,  3, 3, 2, 2,  1, 1, 0, 0,  3, 3, 2, 2,
    1, 0, 0, 1,  3, 2, 2, 3,  1, 0, 0, 1,  3, 2, 2, 3,

    2, 2, 3, 3,  0, 0, 1, 1,  2, 2, 3, 3,  0, 0, 1, 1,  
    2, 3, 3, 2,  0, 1, 1, 0,  2, 3, 3, 2,  0, 1, 1, 0,  
    3, 3, 2, 2,  1, 1, 0, 0,  3, 3, 2, 2,  1, 1, 0, 0,  
    3, 2, 2, 3,  1, 0, 0, 1,  3, 2, 2, 3,  1, 0, 0, 1,  

    // 0,1 shift
    0, 1, 0, 1,  0, 1, 0, 1,  2, 3, 2, 3,  2, 3, 2, 3,
    1, 0, 1, 0,  1, 0, 1, 0,  3, 2, 3, 2,  3, 2, 3, 2,
    0, 1, 0, 1,  0, 1, 0, 1,  2, 3, 2, 3,  2, 3, 2, 3,
    1, 0, 1, 0,  1, 0, 1, 0,  3, 2, 3, 2,  3, 2, 3, 2,
    
    0, 1, 0, 1,  2, 3, 2, 3,  2, 3, 2, 3,  0, 1, 0, 1,  
    1, 0, 1, 0,  3, 2, 3, 2,  3, 2, 3, 2,  1, 0, 1, 0,  
    0, 1, 0, 1,  2, 3, 2, 3,  2, 3, 2, 3,  0, 1, 0, 1,  
    1, 0, 1, 0,  3, 2, 3, 2,  3, 2, 3, 2,  1, 0, 1, 0,  

    2, 3, 2, 3,  2, 3, 2, 3,  0, 1, 0, 1,  0, 1, 0, 1,  
    3, 2, 3, 2,  3, 2, 3, 2,  1, 0, 1, 0,  1, 0, 1, 0,  
    2, 3, 2, 3,  2, 3, 2, 3,  0, 1, 0, 1,  0, 1, 0, 1,  
    3, 2, 3, 2,  3, 2, 3, 2,  1, 0, 1, 0,  1, 0, 1, 0,  

    2, 3, 2, 3,  0, 1, 0, 1,  0, 1, 0, 1,  2, 3, 2, 3,  
    3, 2, 3, 2,  1, 0, 1, 0,  1, 0, 1, 0,  3, 2, 3, 2,  
    2, 3, 2, 3,  0, 1, 0, 1,  0, 1, 0, 1,  2, 3, 2, 3,  
    3, 2, 3, 2,  1, 0, 1, 0,  1, 0, 1, 0,  3, 2, 3, 2,  

    // 1,1 shift
    0, 0, 1, 1,  0, 0, 1, 1,  2, 2, 3, 3,  2, 2, 3, 3,
    0, 1, 1, 0,  0, 1, 1, 0,  2, 3, 3, 2,  2, 3, 3, 2,
    1, 1, 0, 0,  1, 1, 0, 0,  3, 3, 2, 2,  3, 3, 2, 2,
    1, 0, 0, 1,  1, 0, 0, 1,  3, 2, 2, 3,  3, 2, 2, 3,
    
    0, 0, 1, 1,  2, 2, 3, 3,  2, 2, 3, 3,  0, 0, 1, 1,
    0, 1, 1, 0,  2, 3, 3, 2,  2, 3, 3, 2,  0, 1, 1, 0,
    1, 1, 0, 0,  3, 3, 2, 2,  3, 3, 2, 2,  1, 1, 0, 0,
    1, 0, 0, 1,  3, 2, 2, 3,  3, 2, 2, 3,  1, 0, 0, 1,
    
    2, 2, 3, 3,  2, 2, 3, 3,  0, 0, 1, 1,  0, 0, 1, 1,
    2, 3, 3, 2,  2, 3, 3, 2,  0, 1, 1, 0,  0, 1, 1, 0,
    3, 3, 2, 2,  3, 3, 2, 2,  1, 1, 0, 0,  1, 1, 0, 0,
    3, 2, 2, 3,  3, 2, 2, 3,  1, 0, 0, 1,  1, 0, 0, 1,

    2, 2, 3, 3,  0, 0, 1, 1,  0, 0, 1, 1,  2, 2, 3, 3,
    2, 3, 3, 2,  0, 1, 1, 0,  0, 1, 1, 0,  2, 3, 3, 2, 
    3, 3, 2, 2,  1, 1, 0, 0,  1, 1, 0, 0,  3, 3, 2, 2,
    3, 2, 2, 3,  1, 0, 0, 1,  1, 0, 0, 1,  3, 2, 2, 3,
};



/// Tables of rank indexes for different alignment of LRD grid.
const int rankTable[4][9] =
{
    {0, 1, 4, 2, 3, 6, 8, 9, 12}, // 0,0 (x,y)
    {1, 4, 5, 3, 6, 7, 9, 12, 13}, // 1,0
    {2, 3, 6, 8, 9, 12, 10, 11, 14}, // 0,1
    {3, 6, 7, 9, 12, 13, 11, 14, 15}, // 1,1
};


// LRD masks for different feature alignment
const int128 masks[4] = 
{
    { {
          0x01, 0x01, 0x01, 0x01,
          0x01, 0x00, 0x01, 0x00,
          0x01, 0x01, 0x00, 0x00,
          0x01, 0x00, 0x00, 0x00,
    } },
    { {
          0x00, 0x01, 0x00, 0x01,
          0x01, 0x01, 0x01, 0x01,
          0x00, 0x01, 0x00, 0x00,
          0x01, 0x01, 0x00, 0x00,
    } },
    { {
          0x00, 0x00, 0x01, 0x01,
          0x00, 0x00, 0x01, 0x00,
          0x01, 0x01, 0x01, 0x01,
          0x01, 0x00, 0x01, 0x00,
    } },
    { {
          0x00, 0x00, 0x00, 0x01,
          0x00, 0x00, 0x01, 0x01,
          0x00, 0x01, 0x00, 0x01,
          0x01, 0x01, 0x01, 0x01,
    } },
};
